// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Specifies the inventory configuration for an Amazon S3 bucket. For more information, see [GET Bucket inventory](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketGETInventoryConfig.html) in the *Amazon S3 API Reference*.
 */
public class InventoryConfiguration private constructor(builder: Builder) {
    /**
     * Contains information about where to publish the inventory results.
     */
    public val destination: aws.sdk.kotlin.services.s3.model.InventoryDestination? = builder.destination
    /**
     * Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.
     */
    public val filter: aws.sdk.kotlin.services.s3.model.InventoryFilter? = builder.filter
    /**
     * The ID used to identify the inventory configuration.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Object versions to include in the inventory list. If set to `All`, the list includes all the object versions, which adds the version-related fields `VersionId`, `IsLatest`, and `DeleteMarker` to the list. If set to `Current`, the list does not contain these version-related fields.
     */
    public val includedObjectVersions: aws.sdk.kotlin.services.s3.model.InventoryIncludedObjectVersions? = builder.includedObjectVersions
    /**
     * Specifies whether the inventory is enabled or disabled. If set to `True`, an inventory list is generated. If set to `False`, no inventory list is generated.
     */
    public val isEnabled: kotlin.Boolean = builder.isEnabled
    /**
     * Contains the optional fields that are included in the inventory results.
     */
    public val optionalFields: List<InventoryOptionalField>? = builder.optionalFields
    /**
     * Specifies the schedule for generating inventory results.
     */
    public val schedule: aws.sdk.kotlin.services.s3.model.InventorySchedule? = builder.schedule

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.InventoryConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InventoryConfiguration(")
        append("destination=$destination,")
        append("filter=$filter,")
        append("id=$id,")
        append("includedObjectVersions=$includedObjectVersions,")
        append("isEnabled=$isEnabled,")
        append("optionalFields=$optionalFields,")
        append("schedule=$schedule)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (includedObjectVersions?.hashCode() ?: 0)
        result = 31 * result + (isEnabled.hashCode())
        result = 31 * result + (optionalFields?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InventoryConfiguration

        if (destination != other.destination) return false
        if (filter != other.filter) return false
        if (id != other.id) return false
        if (includedObjectVersions != other.includedObjectVersions) return false
        if (isEnabled != other.isEnabled) return false
        if (optionalFields != other.optionalFields) return false
        if (schedule != other.schedule) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.InventoryConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains information about where to publish the inventory results.
         */
        public var destination: aws.sdk.kotlin.services.s3.model.InventoryDestination? = null
        /**
         * Specifies an inventory filter. The inventory only includes objects that meet the filter's criteria.
         */
        public var filter: aws.sdk.kotlin.services.s3.model.InventoryFilter? = null
        /**
         * The ID used to identify the inventory configuration.
         */
        public var id: kotlin.String? = null
        /**
         * Object versions to include in the inventory list. If set to `All`, the list includes all the object versions, which adds the version-related fields `VersionId`, `IsLatest`, and `DeleteMarker` to the list. If set to `Current`, the list does not contain these version-related fields.
         */
        public var includedObjectVersions: aws.sdk.kotlin.services.s3.model.InventoryIncludedObjectVersions? = null
        /**
         * Specifies whether the inventory is enabled or disabled. If set to `True`, an inventory list is generated. If set to `False`, no inventory list is generated.
         */
        public var isEnabled: kotlin.Boolean = false
        /**
         * Contains the optional fields that are included in the inventory results.
         */
        public var optionalFields: List<InventoryOptionalField>? = null
        /**
         * Specifies the schedule for generating inventory results.
         */
        public var schedule: aws.sdk.kotlin.services.s3.model.InventorySchedule? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.InventoryConfiguration) : this() {
            this.destination = x.destination
            this.filter = x.filter
            this.id = x.id
            this.includedObjectVersions = x.includedObjectVersions
            this.isEnabled = x.isEnabled
            this.optionalFields = x.optionalFields
            this.schedule = x.schedule
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.InventoryConfiguration = InventoryConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.InventoryDestination] inside the given [block]
         */
        public fun destination(block: aws.sdk.kotlin.services.s3.model.InventoryDestination.Builder.() -> kotlin.Unit) {
            this.destination = aws.sdk.kotlin.services.s3.model.InventoryDestination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.InventoryFilter] inside the given [block]
         */
        public fun filter(block: aws.sdk.kotlin.services.s3.model.InventoryFilter.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.s3.model.InventoryFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.InventorySchedule] inside the given [block]
         */
        public fun schedule(block: aws.sdk.kotlin.services.s3.model.InventorySchedule.Builder.() -> kotlin.Unit) {
            this.schedule = aws.sdk.kotlin.services.s3.model.InventorySchedule.invoke(block)
        }
    }
}
