// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * This is used in a Lifecycle Rule Filter to apply a logical AND to two or more predicates. The Lifecycle Rule will apply to any object matching all of the predicates configured inside the And operator.
 */
public class LifecycleRuleAndOperator private constructor(builder: Builder) {
    /**
     * Minimum object size to which the rule applies.
     */
    public val objectSizeGreaterThan: kotlin.Long = builder.objectSizeGreaterThan
    /**
     * Maximum object size to which the rule applies.
     */
    public val objectSizeLessThan: kotlin.Long = builder.objectSizeLessThan
    /**
     * Prefix identifying one or more objects to which the rule applies.
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * All of these tags must exist in the object's tag set in order for the rule to apply.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.LifecycleRuleAndOperator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecycleRuleAndOperator(")
        append("objectSizeGreaterThan=$objectSizeGreaterThan,")
        append("objectSizeLessThan=$objectSizeLessThan,")
        append("prefix=$prefix,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = objectSizeGreaterThan.hashCode()
        result = 31 * result + (objectSizeLessThan.hashCode())
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecycleRuleAndOperator

        if (objectSizeGreaterThan != other.objectSizeGreaterThan) return false
        if (objectSizeLessThan != other.objectSizeLessThan) return false
        if (prefix != other.prefix) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.LifecycleRuleAndOperator = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Minimum object size to which the rule applies.
         */
        public var objectSizeGreaterThan: kotlin.Long = 0L
        /**
         * Maximum object size to which the rule applies.
         */
        public var objectSizeLessThan: kotlin.Long = 0L
        /**
         * Prefix identifying one or more objects to which the rule applies.
         */
        public var prefix: kotlin.String? = null
        /**
         * All of these tags must exist in the object's tag set in order for the rule to apply.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.LifecycleRuleAndOperator) : this() {
            this.objectSizeGreaterThan = x.objectSizeGreaterThan
            this.objectSizeLessThan = x.objectSizeLessThan
            this.prefix = x.prefix
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.LifecycleRuleAndOperator = LifecycleRuleAndOperator(this)
    }
}
