// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Specifies how requests are redirected. In the event of an error, you can specify a different error code to return.
 */
public class Redirect private constructor(builder: Builder) {
    /**
     * The host name to use in the redirect request.
     */
    public val hostName: kotlin.String? = builder.hostName
    /**
     * The HTTP redirect code to use on the response. Not required if one of the siblings is present.
     */
    public val httpRedirectCode: kotlin.String? = builder.httpRedirectCode
    /**
     * Protocol to use when redirecting requests. The default is the protocol that is used in the original request.
     */
    public val protocol: aws.sdk.kotlin.services.s3.model.Protocol? = builder.protocol
    /**
     * The object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix `docs/` (objects in the `docs/` folder) to `documents/`, you can set a condition block with `KeyPrefixEquals` set to `docs/` and in the Redirect set `ReplaceKeyPrefixWith` to `/documents`. Not required if one of the siblings is present. Can be present only if `ReplaceKeyWith` is not provided.
     *
     * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
     */
    public val replaceKeyPrefixWith: kotlin.String? = builder.replaceKeyPrefixWith
    /**
     * The specific object key to use in the redirect request. For example, redirect request to `error.html`. Not required if one of the siblings is present. Can be present only if `ReplaceKeyPrefixWith` is not provided.
     *
     * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
     */
    public val replaceKeyWith: kotlin.String? = builder.replaceKeyWith

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.Redirect = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Redirect(")
        append("hostName=$hostName,")
        append("httpRedirectCode=$httpRedirectCode,")
        append("protocol=$protocol,")
        append("replaceKeyPrefixWith=$replaceKeyPrefixWith,")
        append("replaceKeyWith=$replaceKeyWith)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostName?.hashCode() ?: 0
        result = 31 * result + (httpRedirectCode?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (replaceKeyPrefixWith?.hashCode() ?: 0)
        result = 31 * result + (replaceKeyWith?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Redirect

        if (hostName != other.hostName) return false
        if (httpRedirectCode != other.httpRedirectCode) return false
        if (protocol != other.protocol) return false
        if (replaceKeyPrefixWith != other.replaceKeyPrefixWith) return false
        if (replaceKeyWith != other.replaceKeyWith) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.Redirect = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The host name to use in the redirect request.
         */
        public var hostName: kotlin.String? = null
        /**
         * The HTTP redirect code to use on the response. Not required if one of the siblings is present.
         */
        public var httpRedirectCode: kotlin.String? = null
        /**
         * Protocol to use when redirecting requests. The default is the protocol that is used in the original request.
         */
        public var protocol: aws.sdk.kotlin.services.s3.model.Protocol? = null
        /**
         * The object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix `docs/` (objects in the `docs/` folder) to `documents/`, you can set a condition block with `KeyPrefixEquals` set to `docs/` and in the Redirect set `ReplaceKeyPrefixWith` to `/documents`. Not required if one of the siblings is present. Can be present only if `ReplaceKeyWith` is not provided.
         *
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
         */
        public var replaceKeyPrefixWith: kotlin.String? = null
        /**
         * The specific object key to use in the redirect request. For example, redirect request to `error.html`. Not required if one of the siblings is present. Can be present only if `ReplaceKeyPrefixWith` is not provided.
         *
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
         */
        public var replaceKeyWith: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.Redirect) : this() {
            this.hostName = x.hostName
            this.httpRedirectCode = x.httpRedirectCode
            this.protocol = x.protocol
            this.replaceKeyPrefixWith = x.replaceKeyPrefixWith
            this.replaceKeyWith = x.replaceKeyWith
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.Redirect = Redirect(this)
    }
}
