// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Container for restore job parameters.
 */
public class RestoreRequest private constructor(builder: Builder) {
    /**
     * Lifetime of the active copy in days. Do not use with restores that specify `OutputLocation`.
     *
     * The Days element is required for regular restores, and must not be provided for select requests.
     */
    public val days: kotlin.Int = builder.days
    /**
     * The optional description for the job.
     */
    public val description: kotlin.String? = builder.description
    /**
     * S3 Glacier related parameters pertaining to this job. Do not use with restores that specify `OutputLocation`.
     */
    public val glacierJobParameters: aws.sdk.kotlin.services.s3.model.GlacierJobParameters? = builder.glacierJobParameters
    /**
     * Describes the location where the restore job's output is stored.
     */
    public val outputLocation: aws.sdk.kotlin.services.s3.model.OutputLocation? = builder.outputLocation
    /**
     * Describes the parameters for Select job types.
     */
    public val selectParameters: aws.sdk.kotlin.services.s3.model.SelectParameters? = builder.selectParameters
    /**
     * Retrieval tier at which the restore will be processed.
     */
    public val tier: aws.sdk.kotlin.services.s3.model.Tier? = builder.tier
    /**
     * Type of restore request.
     */
    public val type: aws.sdk.kotlin.services.s3.model.RestoreRequestType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.RestoreRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreRequest(")
        append("days=$days,")
        append("description=$description,")
        append("glacierJobParameters=$glacierJobParameters,")
        append("outputLocation=$outputLocation,")
        append("selectParameters=$selectParameters,")
        append("tier=$tier,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = days
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (glacierJobParameters?.hashCode() ?: 0)
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (selectParameters?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreRequest

        if (days != other.days) return false
        if (description != other.description) return false
        if (glacierJobParameters != other.glacierJobParameters) return false
        if (outputLocation != other.outputLocation) return false
        if (selectParameters != other.selectParameters) return false
        if (tier != other.tier) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.RestoreRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Lifetime of the active copy in days. Do not use with restores that specify `OutputLocation`.
         *
         * The Days element is required for regular restores, and must not be provided for select requests.
         */
        public var days: kotlin.Int = 0
        /**
         * The optional description for the job.
         */
        public var description: kotlin.String? = null
        /**
         * S3 Glacier related parameters pertaining to this job. Do not use with restores that specify `OutputLocation`.
         */
        public var glacierJobParameters: aws.sdk.kotlin.services.s3.model.GlacierJobParameters? = null
        /**
         * Describes the location where the restore job's output is stored.
         */
        public var outputLocation: aws.sdk.kotlin.services.s3.model.OutputLocation? = null
        /**
         * Describes the parameters for Select job types.
         */
        public var selectParameters: aws.sdk.kotlin.services.s3.model.SelectParameters? = null
        /**
         * Retrieval tier at which the restore will be processed.
         */
        public var tier: aws.sdk.kotlin.services.s3.model.Tier? = null
        /**
         * Type of restore request.
         */
        public var type: aws.sdk.kotlin.services.s3.model.RestoreRequestType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.RestoreRequest) : this() {
            this.days = x.days
            this.description = x.description
            this.glacierJobParameters = x.glacierJobParameters
            this.outputLocation = x.outputLocation
            this.selectParameters = x.selectParameters
            this.tier = x.tier
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.RestoreRequest = RestoreRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.GlacierJobParameters] inside the given [block]
         */
        public fun glacierJobParameters(block: aws.sdk.kotlin.services.s3.model.GlacierJobParameters.Builder.() -> kotlin.Unit) {
            this.glacierJobParameters = aws.sdk.kotlin.services.s3.model.GlacierJobParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.OutputLocation] inside the given [block]
         */
        public fun outputLocation(block: aws.sdk.kotlin.services.s3.model.OutputLocation.Builder.() -> kotlin.Unit) {
            this.outputLocation = aws.sdk.kotlin.services.s3.model.OutputLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.SelectParameters] inside the given [block]
         */
        public fun selectParameters(block: aws.sdk.kotlin.services.s3.model.SelectParameters.Builder.() -> kotlin.Unit) {
            this.selectParameters = aws.sdk.kotlin.services.s3.model.SelectParameters.invoke(block)
        }
    }
}
