// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Container for granting information.
 *
 * Buckets that use the bucket owner enforced setting for Object Ownership don't support target grants. For more information, see [Permissions server access log delivery](https://docs.aws.amazon.com/AmazonS3/latest/userguide/enable-server-access-logging.html#grant-log-delivery-permissions-general) in the *Amazon S3 User Guide*.
 */
public class TargetGrant private constructor(builder: Builder) {
    /**
     * Container for the person being granted permissions.
     */
    public val grantee: aws.sdk.kotlin.services.s3.model.Grantee? = builder.grantee
    /**
     * Logging permissions assigned to the grantee for the bucket.
     */
    public val permission: aws.sdk.kotlin.services.s3.model.BucketLogsPermission? = builder.permission

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.TargetGrant = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetGrant(")
        append("grantee=$grantee,")
        append("permission=$permission)")
    }

    override fun hashCode(): kotlin.Int {
        var result = grantee?.hashCode() ?: 0
        result = 31 * result + (permission?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetGrant

        if (grantee != other.grantee) return false
        if (permission != other.permission) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.TargetGrant = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Container for the person being granted permissions.
         */
        public var grantee: aws.sdk.kotlin.services.s3.model.Grantee? = null
        /**
         * Logging permissions assigned to the grantee for the bucket.
         */
        public var permission: aws.sdk.kotlin.services.s3.model.BucketLogsPermission? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.TargetGrant) : this() {
            this.grantee = x.grantee
            this.permission = x.permission
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.TargetGrant = TargetGrant(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.Grantee] inside the given [block]
         */
        public fun grantee(block: aws.sdk.kotlin.services.s3.model.Grantee.Builder.() -> kotlin.Unit) {
            this.grantee = aws.sdk.kotlin.services.s3.model.Grantee.invoke(block)
        }
    }
}
