// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.transform

import aws.sdk.kotlin.services.s3.model.ListPartsRequest
import aws.sdk.kotlin.services.s3.model.RequestPayer
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.parameters
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel


internal class ListPartsOperationSerializer: HttpSerialize<ListPartsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListPartsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            val pathSegments = listOf(
                "${input.bucket}".encodeLabel(),
                "${input.key}".encodeLabel(greedy = true),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                append("x-id", "ListParts")
                if (input.maxParts != 0) append("max-parts", "${input.maxParts}")
                if (input.partNumberMarker != null) append("part-number-marker", input.partNumberMarker)
                if (input.uploadId != null) append("uploadId", input.uploadId)
            }
        }

        builder.headers {
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
            if (input.requestPayer != null) append("x-amz-request-payer", input.requestPayer.value)
            if (input.sseCustomerAlgorithm?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-algorithm", input.sseCustomerAlgorithm)
            if (input.sseCustomerKey?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key", input.sseCustomerKey)
            if (input.sseCustomerKeyMd5?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key-MD5", input.sseCustomerKeyMd5)
        }

        return builder
    }
}
