// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.transform

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.eventstream.MessageType
import aws.sdk.kotlin.runtime.protocol.eventstream.decodeFrames
import aws.sdk.kotlin.runtime.protocol.eventstream.type
import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.ProgressEvent
import aws.sdk.kotlin.services.s3.model.RecordsEvent
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.sdk.kotlin.services.s3.model.SelectObjectContentEventStream
import aws.sdk.kotlin.services.s3.model.SelectObjectContentResponse
import aws.sdk.kotlin.services.s3.model.StatsEvent
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.http.toSdkByteReadChannel
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map


internal class SelectObjectContentOperationDeserializer: HttpDeserialize<SelectObjectContentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SelectObjectContentResponse {
        if (!response.status.isSuccess()) {
            throwSelectObjectContentError(context, response)
        }
        val builder = SelectObjectContentResponse.Builder()

        deserializeSelectObjectContentOperationBody(builder, response.body)
        return builder.build()
    }
}

private suspend fun throwSelectObjectContentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        if (payload == null && response.status == HttpStatusCode.NotFound) {
            S3ErrorDetails(code = "NotFound")
        } else {
            checkNotNull(payload){ "unable to parse error from empty response" }
            parseS3ErrorResponse(payload)
        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as 'restXml' error", ex).also {
            setS3ErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

internal suspend fun deserializeSelectObjectContentOperationBody(builder: SelectObjectContentResponse.Builder, body: HttpBody) {
    val chan = body.toSdkByteReadChannel() ?: return
    val events = decodeFrames(chan)
        .map { message ->
            when(val mt = message.type()) {
                is MessageType.Event -> when(mt.shapeType) {
                    "Records" -> {
                        val eb = RecordsEvent.Builder()
                        eb.payload = message.payload
                        val e = eb.build()
                        SelectObjectContentEventStream.Records(e)
                    }
                    "Stats" -> {
                        val eb = StatsEvent.Builder()
                        eb.details = deserializeStatsPayload(message.payload)
                        val e = eb.build()
                        SelectObjectContentEventStream.Stats(e)
                    }
                    "Progress" -> {
                        val eb = ProgressEvent.Builder()
                        eb.details = deserializeProgressPayload(message.payload)
                        val e = eb.build()
                        SelectObjectContentEventStream.Progress(e)
                    }
                    "Cont" -> {
                        val e = deserializeContinuationEventPayload(message.payload)
                        SelectObjectContentEventStream.Cont(e)
                    }
                    "End" -> {
                        val e = deserializeEndEventPayload(message.payload)
                        SelectObjectContentEventStream.End(e)
                    }
                    else -> SelectObjectContentEventStream.SdkUnknown
                }
                is MessageType.Exception -> when(mt.shapeType){
                    else -> throw S3Exception("error processing event stream, unrecognized errorType: ${mt.shapeType}")
                }
                is MessageType.Error -> throw S3Exception("error processing event stream: errorCode=${mt.errorCode}; message=${mt.message}")
                is MessageType.SdkUnknown -> throw ClientException("unrecognized event stream message `:message-type`: ${mt.messageType}")
            }
        }
    builder.payload = events
}
