// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3

import aws.sdk.kotlin.runtime.auth.credentials.StaticCredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.AwsEndpoint
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.s3.model.*
import aws.smithy.kotlin.runtime.auth.awscredentials.Credentials
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.smithy.test.*
import kotlin.test.Test


class CreateBucketRequestTest {
    /**
     * Validates https://github.com/awslabs/aws-sdk-kotlin/issues/567 (empty body)
     */
    @Test
    fun `CreateBucketNoBody`() = httpRequestTest {
        expected {
            method = HttpMethod.PUT
            uri = "/mybucket"
            forbiddenHeaders = listOf("Content-Type","Content-Length")
            bodyAssert = ::assertEmptyBody

        }

        operation { mockEngine ->

            val input = CreateBucketRequest {
                    bucket = "mybucket"
                }

            val service = S3Client {
                httpClientEngine = mockEngine
                val credentials = Credentials("AKID", "SECRET")
                credentialsProvider = StaticCredentialsProvider(credentials)
                region = "us-east-1"
                endpointResolver = AwsEndpointResolver { _, _ -> AwsEndpoint("https://s3.us-west-2.amazonaws.com") }
            }
            service.createBucket(input)
        }
    }
    /**
     * This test case validates https://github.com/awslabs/aws-sdk-kotlin/issues/567 (non-empty body)
     */
    @Test
    fun `CreateBucketWithBody`() = httpRequestTest {
        expected {
            method = HttpMethod.PUT
            uri = "/mybucket"
            headers = mapOf(
                "Content-Length" to "153",
                "Content-Type" to "application/xml"
            )
            body = """<CreateBucketConfiguration xmlns="http://s3.amazonaws.com/doc/2006-03-01/"><LocationConstraint>us-east-2</LocationConstraint></CreateBucketConfiguration>"""
            bodyAssert = ::assertBytesEqual

        }

        operation { mockEngine ->

            val input = CreateBucketRequest {
                    bucket = "mybucket"
                    createBucketConfiguration = CreateBucketConfiguration {
                        locationConstraint = BucketLocationConstraint.fromValue("us-east-2")
                    }

                }

            val service = S3Client {
                httpClientEngine = mockEngine
                val credentials = Credentials("AKID", "SECRET")
                credentialsProvider = StaticCredentialsProvider(credentials)
                region = "us-east-1"
                endpointResolver = AwsEndpointResolver { _, _ -> AwsEndpoint("https://s3.us-west-2.amazonaws.com") }
            }
            service.createBucket(input)
        }
    }
}
