// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * An access point used to access a bucket.
 */
class AccessPoint private constructor(builder: Builder) {
    /**
     * The ARN for the access point.
     */
    val accessPointArn: kotlin.String? = builder.accessPointArn
    /**
     * The name or alias of the access point.
     */
    val alias: kotlin.String? = builder.alias
    /**
     * The name of the bucket associated with this access point.
     */
    val bucket: kotlin.String? = builder.bucket
    /**
     * The name of this access point.
     */
    val name: kotlin.String? = builder.name
    /**
     * Indicates whether this access point allows access from the public internet. If `VpcConfiguration` is specified for this access point, then `NetworkOrigin` is `VPC`, and the access point doesn't allow access from the public internet. Otherwise, `NetworkOrigin` is `Internet`, and the access point allows access from the public internet, subject to the access point and bucket access policies.
     */
    val networkOrigin: aws.sdk.kotlin.services.s3control.model.NetworkOrigin? = builder.networkOrigin
    /**
     * The virtual private cloud (VPC) configuration for this access point, if one exists.
     *
     * This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.
     */
    val vpcConfiguration: aws.sdk.kotlin.services.s3control.model.VpcConfiguration? = builder.vpcConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.AccessPoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessPoint(")
        append("accessPointArn=$accessPointArn,")
        append("alias=$alias,")
        append("bucket=$bucket,")
        append("name=$name,")
        append("networkOrigin=$networkOrigin,")
        append("vpcConfiguration=$vpcConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPointArn?.hashCode() ?: 0
        result = 31 * result + (alias?.hashCode() ?: 0)
        result = 31 * result + (bucket?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkOrigin?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessPoint

        if (accessPointArn != other.accessPointArn) return false
        if (alias != other.alias) return false
        if (bucket != other.bucket) return false
        if (name != other.name) return false
        if (networkOrigin != other.networkOrigin) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.AccessPoint = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN for the access point.
         */
        var accessPointArn: kotlin.String? = null
        /**
         * The name or alias of the access point.
         */
        var alias: kotlin.String? = null
        /**
         * The name of the bucket associated with this access point.
         */
        var bucket: kotlin.String? = null
        /**
         * The name of this access point.
         */
        var name: kotlin.String? = null
        /**
         * Indicates whether this access point allows access from the public internet. If `VpcConfiguration` is specified for this access point, then `NetworkOrigin` is `VPC`, and the access point doesn't allow access from the public internet. Otherwise, `NetworkOrigin` is `Internet`, and the access point allows access from the public internet, subject to the access point and bucket access policies.
         */
        var networkOrigin: aws.sdk.kotlin.services.s3control.model.NetworkOrigin? = null
        /**
         * The virtual private cloud (VPC) configuration for this access point, if one exists.
         *
         * This element is empty if this access point is an Amazon S3 on Outposts access point that is used by other Amazon Web Services.
         */
        var vpcConfiguration: aws.sdk.kotlin.services.s3control.model.VpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.AccessPoint) : this() {
            this.accessPointArn = x.accessPointArn
            this.alias = x.alias
            this.bucket = x.bucket
            this.name = x.name
            this.networkOrigin = x.networkOrigin
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.AccessPoint = AccessPoint(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.VpcConfiguration] inside the given [block]
         */
        fun vpcConfiguration(block: aws.sdk.kotlin.services.s3control.model.VpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.s3control.model.VpcConfiguration.invoke(block)
        }
    }
}
