// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A container element for the job configuration and status information returned by a `Describe Job` request.
 */
class JobDescriptor private constructor(builder: Builder) {
    /**
     * Indicates whether confirmation is required before Amazon S3 begins running the specified job. Confirmation is required only for jobs created through the Amazon S3 console.
     */
    val confirmationRequired: kotlin.Boolean = builder.confirmationRequired
    /**
     * A timestamp indicating when this job was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The description for this job, if one was provided in this job's `Create Job` request.
     */
    val description: kotlin.String? = builder.description
    /**
     * If the specified job failed, this field contains information describing the failure.
     */
    val failureReasons: List<JobFailure>? = builder.failureReasons
    /**
     * The attribute of the JobDescriptor containing details about the job's generated manifest.
     */
    val generatedManifestDescriptor: aws.sdk.kotlin.services.s3control.model.S3GeneratedManifestDescriptor? = builder.generatedManifestDescriptor
    /**
     * The Amazon Resource Name (ARN) for this job.
     */
    val jobArn: kotlin.String? = builder.jobArn
    /**
     * The ID for the specified job.
     */
    val jobId: kotlin.String? = builder.jobId
    /**
     * The configuration information for the specified job's manifest object.
     */
    val manifest: aws.sdk.kotlin.services.s3control.model.JobManifest? = builder.manifest
    /**
     * The manifest generator that was used to generate a job manifest for this job.
     */
    val manifestGenerator: aws.sdk.kotlin.services.s3control.model.JobManifestGenerator? = builder.manifestGenerator
    /**
     * The operation that the specified job is configured to run on the objects listed in the manifest.
     */
    val operation: aws.sdk.kotlin.services.s3control.model.JobOperation? = builder.operation
    /**
     * The priority of the specified job.
     */
    val priority: kotlin.Int = builder.priority
    /**
     * Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.
     */
    val progressSummary: aws.sdk.kotlin.services.s3control.model.JobProgressSummary? = builder.progressSummary
    /**
     * Contains the configuration information for the job-completion report if you requested one in the `Create Job` request.
     */
    val report: aws.sdk.kotlin.services.s3control.model.JobReport? = builder.report
    /**
     * The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role assigned to run the tasks for this job.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The current status of the specified job.
     */
    val status: aws.sdk.kotlin.services.s3control.model.JobStatus? = builder.status
    /**
     * The reason for updating the job.
     */
    val statusUpdateReason: kotlin.String? = builder.statusUpdateReason
    /**
     * The reason why the specified job was suspended. A job is only suspended if you create it through the Amazon S3 console. When you create the job, it enters the `Suspended` state to await confirmation before running. After you confirm the job, it automatically exits the `Suspended` state.
     */
    val suspendedCause: kotlin.String? = builder.suspendedCause
    /**
     * The timestamp when this job was suspended, if it has been suspended.
     */
    val suspendedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.suspendedDate
    /**
     * A timestamp indicating when this job terminated. A job's termination date is the date and time when it succeeded, failed, or was canceled.
     */
    val terminationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.terminationDate

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.JobDescriptor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobDescriptor(")
        append("confirmationRequired=$confirmationRequired,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("failureReasons=$failureReasons,")
        append("generatedManifestDescriptor=$generatedManifestDescriptor,")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("manifest=$manifest,")
        append("manifestGenerator=$manifestGenerator,")
        append("operation=$operation,")
        append("priority=$priority,")
        append("progressSummary=$progressSummary,")
        append("report=$report,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("statusUpdateReason=$statusUpdateReason,")
        append("suspendedCause=$suspendedCause,")
        append("suspendedDate=$suspendedDate,")
        append("terminationDate=$terminationDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = confirmationRequired.hashCode()
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (failureReasons?.hashCode() ?: 0)
        result = 31 * result + (generatedManifestDescriptor?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (manifest?.hashCode() ?: 0)
        result = 31 * result + (manifestGenerator?.hashCode() ?: 0)
        result = 31 * result + (operation?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (progressSummary?.hashCode() ?: 0)
        result = 31 * result + (report?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusUpdateReason?.hashCode() ?: 0)
        result = 31 * result + (suspendedCause?.hashCode() ?: 0)
        result = 31 * result + (suspendedDate?.hashCode() ?: 0)
        result = 31 * result + (terminationDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobDescriptor

        if (confirmationRequired != other.confirmationRequired) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (failureReasons != other.failureReasons) return false
        if (generatedManifestDescriptor != other.generatedManifestDescriptor) return false
        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (manifest != other.manifest) return false
        if (manifestGenerator != other.manifestGenerator) return false
        if (operation != other.operation) return false
        if (priority != other.priority) return false
        if (progressSummary != other.progressSummary) return false
        if (report != other.report) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (statusUpdateReason != other.statusUpdateReason) return false
        if (suspendedCause != other.suspendedCause) return false
        if (suspendedDate != other.suspendedDate) return false
        if (terminationDate != other.terminationDate) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.JobDescriptor = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether confirmation is required before Amazon S3 begins running the specified job. Confirmation is required only for jobs created through the Amazon S3 console.
         */
        var confirmationRequired: kotlin.Boolean = false
        /**
         * A timestamp indicating when this job was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for this job, if one was provided in this job's `Create Job` request.
         */
        var description: kotlin.String? = null
        /**
         * If the specified job failed, this field contains information describing the failure.
         */
        var failureReasons: List<JobFailure>? = null
        /**
         * The attribute of the JobDescriptor containing details about the job's generated manifest.
         */
        var generatedManifestDescriptor: aws.sdk.kotlin.services.s3control.model.S3GeneratedManifestDescriptor? = null
        /**
         * The Amazon Resource Name (ARN) for this job.
         */
        var jobArn: kotlin.String? = null
        /**
         * The ID for the specified job.
         */
        var jobId: kotlin.String? = null
        /**
         * The configuration information for the specified job's manifest object.
         */
        var manifest: aws.sdk.kotlin.services.s3control.model.JobManifest? = null
        /**
         * The manifest generator that was used to generate a job manifest for this job.
         */
        var manifestGenerator: aws.sdk.kotlin.services.s3control.model.JobManifestGenerator? = null
        /**
         * The operation that the specified job is configured to run on the objects listed in the manifest.
         */
        var operation: aws.sdk.kotlin.services.s3control.model.JobOperation? = null
        /**
         * The priority of the specified job.
         */
        var priority: kotlin.Int = 0
        /**
         * Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.
         */
        var progressSummary: aws.sdk.kotlin.services.s3control.model.JobProgressSummary? = null
        /**
         * Contains the configuration information for the job-completion report if you requested one in the `Create Job` request.
         */
        var report: aws.sdk.kotlin.services.s3control.model.JobReport? = null
        /**
         * The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role assigned to run the tasks for this job.
         */
        var roleArn: kotlin.String? = null
        /**
         * The current status of the specified job.
         */
        var status: aws.sdk.kotlin.services.s3control.model.JobStatus? = null
        /**
         * The reason for updating the job.
         */
        var statusUpdateReason: kotlin.String? = null
        /**
         * The reason why the specified job was suspended. A job is only suspended if you create it through the Amazon S3 console. When you create the job, it enters the `Suspended` state to await confirmation before running. After you confirm the job, it automatically exits the `Suspended` state.
         */
        var suspendedCause: kotlin.String? = null
        /**
         * The timestamp when this job was suspended, if it has been suspended.
         */
        var suspendedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A timestamp indicating when this job terminated. A job's termination date is the date and time when it succeeded, failed, or was canceled.
         */
        var terminationDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.JobDescriptor) : this() {
            this.confirmationRequired = x.confirmationRequired
            this.creationTime = x.creationTime
            this.description = x.description
            this.failureReasons = x.failureReasons
            this.generatedManifestDescriptor = x.generatedManifestDescriptor
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.manifest = x.manifest
            this.manifestGenerator = x.manifestGenerator
            this.operation = x.operation
            this.priority = x.priority
            this.progressSummary = x.progressSummary
            this.report = x.report
            this.roleArn = x.roleArn
            this.status = x.status
            this.statusUpdateReason = x.statusUpdateReason
            this.suspendedCause = x.suspendedCause
            this.suspendedDate = x.suspendedDate
            this.terminationDate = x.terminationDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.JobDescriptor = JobDescriptor(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3GeneratedManifestDescriptor] inside the given [block]
         */
        fun generatedManifestDescriptor(block: aws.sdk.kotlin.services.s3control.model.S3GeneratedManifestDescriptor.Builder.() -> kotlin.Unit) {
            this.generatedManifestDescriptor = aws.sdk.kotlin.services.s3control.model.S3GeneratedManifestDescriptor.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.JobManifest] inside the given [block]
         */
        fun manifest(block: aws.sdk.kotlin.services.s3control.model.JobManifest.Builder.() -> kotlin.Unit) {
            this.manifest = aws.sdk.kotlin.services.s3control.model.JobManifest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.JobOperation] inside the given [block]
         */
        fun operation(block: aws.sdk.kotlin.services.s3control.model.JobOperation.Builder.() -> kotlin.Unit) {
            this.operation = aws.sdk.kotlin.services.s3control.model.JobOperation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.JobProgressSummary] inside the given [block]
         */
        fun progressSummary(block: aws.sdk.kotlin.services.s3control.model.JobProgressSummary.Builder.() -> kotlin.Unit) {
            this.progressSummary = aws.sdk.kotlin.services.s3control.model.JobProgressSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.JobReport] inside the given [block]
         */
        fun report(block: aws.sdk.kotlin.services.s3control.model.JobReport.Builder.() -> kotlin.Unit) {
            this.report = aws.sdk.kotlin.services.s3control.model.JobReport.invoke(block)
        }
    }
}
