// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * Contains the information required to locate a manifest object.
 */
class JobManifestLocation private constructor(builder: Builder) {
    /**
     * The ETag for the specified manifest object.
     */
    val eTag: kotlin.String? = builder.eTag
    /**
     * The Amazon Resource Name (ARN) for a manifest object.
     *
     * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
     */
    val objectArn: kotlin.String? = builder.objectArn
    /**
     * The optional version ID to identify a specific version of the manifest object.
     */
    val objectVersionId: kotlin.String? = builder.objectVersionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.JobManifestLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobManifestLocation(")
        append("eTag=$eTag,")
        append("objectArn=$objectArn,")
        append("objectVersionId=$objectVersionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eTag?.hashCode() ?: 0
        result = 31 * result + (objectArn?.hashCode() ?: 0)
        result = 31 * result + (objectVersionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobManifestLocation

        if (eTag != other.eTag) return false
        if (objectArn != other.objectArn) return false
        if (objectVersionId != other.objectVersionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.JobManifestLocation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ETag for the specified manifest object.
         */
        var eTag: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for a manifest object.
         *
         * Replacement must be made for object keys containing special characters (such as carriage returns) when using XML requests. For more information, see [ XML related object key constraints](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints).
         */
        var objectArn: kotlin.String? = null
        /**
         * The optional version ID to identify a specific version of the manifest object.
         */
        var objectVersionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.JobManifestLocation) : this() {
            this.eTag = x.eTag
            this.objectArn = x.objectArn
            this.objectVersionId = x.objectVersionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.JobManifestLocation = JobManifestLocation(this)
    }
}
