// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * Contains the configuration parameters for a job-completion report.
 */
class JobReport private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the bucket where specified job-completion report will be stored.
     */
    val bucket: kotlin.String? = builder.bucket
    /**
     * Indicates whether the specified job will generate a job-completion report.
     */
    val enabled: kotlin.Boolean = builder.enabled
    /**
     * The format of the specified job-completion report.
     */
    val format: aws.sdk.kotlin.services.s3control.model.JobReportFormat? = builder.format
    /**
     * An optional prefix to describe where in the specified bucket the job-completion report will be stored. Amazon S3 stores the job-completion report at `<prefix>/job-<job-id>/report.json`.
     */
    val prefix: kotlin.String? = builder.prefix
    /**
     * Indicates whether the job-completion report will include details of all tasks or only failed tasks.
     */
    val reportScope: aws.sdk.kotlin.services.s3control.model.JobReportScope? = builder.reportScope

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.JobReport = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobReport(")
        append("bucket=$bucket,")
        append("enabled=$enabled,")
        append("format=$format,")
        append("prefix=$prefix,")
        append("reportScope=$reportScope)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (reportScope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobReport

        if (bucket != other.bucket) return false
        if (enabled != other.enabled) return false
        if (format != other.format) return false
        if (prefix != other.prefix) return false
        if (reportScope != other.reportScope) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.JobReport = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) for the bucket where specified job-completion report will be stored.
         */
        var bucket: kotlin.String? = null
        /**
         * Indicates whether the specified job will generate a job-completion report.
         */
        var enabled: kotlin.Boolean = false
        /**
         * The format of the specified job-completion report.
         */
        var format: aws.sdk.kotlin.services.s3control.model.JobReportFormat? = null
        /**
         * An optional prefix to describe where in the specified bucket the job-completion report will be stored. Amazon S3 stores the job-completion report at `<prefix>/job-<job-id>/report.json`.
         */
        var prefix: kotlin.String? = null
        /**
         * Indicates whether the job-completion report will include details of all tasks or only failed tasks.
         */
        var reportScope: aws.sdk.kotlin.services.s3control.model.JobReportScope? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.JobReport) : this() {
            this.bucket = x.bucket
            this.enabled = x.enabled
            this.format = x.format
            this.prefix = x.prefix
            this.reportScope = x.reportScope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.JobReport = JobReport(this)
    }
}
