// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * The container for the Outposts bucket lifecycle rule.
 */
class LifecycleRule private constructor(builder: Builder) {
    /**
     * Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 waits before permanently removing all parts of the upload. For more information, see [ Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config) in the *Amazon S3 User Guide*.
     */
    val abortIncompleteMultipartUpload: aws.sdk.kotlin.services.s3control.model.AbortIncompleteMultipartUpload? = builder.abortIncompleteMultipartUpload
    /**
     * Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.
     */
    val expiration: aws.sdk.kotlin.services.s3control.model.LifecycleExpiration? = builder.expiration
    /**
     * The container for the filter of lifecycle rule.
     */
    val filter: aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter? = builder.filter
    /**
     * Unique identifier for the rule. The value cannot be longer than 255 characters.
     */
    val id: kotlin.String? = builder.id
    /**
     * The noncurrent version expiration of the lifecycle rule.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    val noncurrentVersionExpiration: aws.sdk.kotlin.services.s3control.model.NoncurrentVersionExpiration? = builder.noncurrentVersionExpiration
    /**
     * Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    val noncurrentVersionTransitions: List<NoncurrentVersionTransition>? = builder.noncurrentVersionTransitions
    /**
     * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
     */
    val status: aws.sdk.kotlin.services.s3control.model.ExpirationStatus? = builder.status
    /**
     * Specifies when an Amazon S3 object transitions to a specified storage class.
     *
     * This is not supported by Amazon S3 on Outposts buckets.
     */
    val transitions: List<Transition>? = builder.transitions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.LifecycleRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecycleRule(")
        append("abortIncompleteMultipartUpload=$abortIncompleteMultipartUpload,")
        append("expiration=$expiration,")
        append("filter=$filter,")
        append("id=$id,")
        append("noncurrentVersionExpiration=$noncurrentVersionExpiration,")
        append("noncurrentVersionTransitions=$noncurrentVersionTransitions,")
        append("status=$status,")
        append("transitions=$transitions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = abortIncompleteMultipartUpload?.hashCode() ?: 0
        result = 31 * result + (expiration?.hashCode() ?: 0)
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (noncurrentVersionExpiration?.hashCode() ?: 0)
        result = 31 * result + (noncurrentVersionTransitions?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (transitions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecycleRule

        if (abortIncompleteMultipartUpload != other.abortIncompleteMultipartUpload) return false
        if (expiration != other.expiration) return false
        if (filter != other.filter) return false
        if (id != other.id) return false
        if (noncurrentVersionExpiration != other.noncurrentVersionExpiration) return false
        if (noncurrentVersionTransitions != other.noncurrentVersionTransitions) return false
        if (status != other.status) return false
        if (transitions != other.transitions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.LifecycleRule = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the days since the initiation of an incomplete multipart upload that Amazon S3 waits before permanently removing all parts of the upload. For more information, see [ Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Policy](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config) in the *Amazon S3 User Guide*.
         */
        var abortIncompleteMultipartUpload: aws.sdk.kotlin.services.s3control.model.AbortIncompleteMultipartUpload? = null
        /**
         * Specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker.
         */
        var expiration: aws.sdk.kotlin.services.s3control.model.LifecycleExpiration? = null
        /**
         * The container for the filter of lifecycle rule.
         */
        var filter: aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter? = null
        /**
         * Unique identifier for the rule. The value cannot be longer than 255 characters.
         */
        var id: kotlin.String? = null
        /**
         * The noncurrent version expiration of the lifecycle rule.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        var noncurrentVersionExpiration: aws.sdk.kotlin.services.s3control.model.NoncurrentVersionExpiration? = null
        /**
         * Specifies the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. If your bucket is versioning-enabled (or versioning is suspended), you can set this action to request that Amazon S3 transition noncurrent object versions to a specific storage class at a set period in the object's lifetime.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        var noncurrentVersionTransitions: List<NoncurrentVersionTransition>? = null
        /**
         * If 'Enabled', the rule is currently being applied. If 'Disabled', the rule is not currently being applied.
         */
        var status: aws.sdk.kotlin.services.s3control.model.ExpirationStatus? = null
        /**
         * Specifies when an Amazon S3 object transitions to a specified storage class.
         *
         * This is not supported by Amazon S3 on Outposts buckets.
         */
        var transitions: List<Transition>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.LifecycleRule) : this() {
            this.abortIncompleteMultipartUpload = x.abortIncompleteMultipartUpload
            this.expiration = x.expiration
            this.filter = x.filter
            this.id = x.id
            this.noncurrentVersionExpiration = x.noncurrentVersionExpiration
            this.noncurrentVersionTransitions = x.noncurrentVersionTransitions
            this.status = x.status
            this.transitions = x.transitions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.LifecycleRule = LifecycleRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.AbortIncompleteMultipartUpload] inside the given [block]
         */
        fun abortIncompleteMultipartUpload(block: aws.sdk.kotlin.services.s3control.model.AbortIncompleteMultipartUpload.Builder.() -> kotlin.Unit) {
            this.abortIncompleteMultipartUpload = aws.sdk.kotlin.services.s3control.model.AbortIncompleteMultipartUpload.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.LifecycleExpiration] inside the given [block]
         */
        fun expiration(block: aws.sdk.kotlin.services.s3control.model.LifecycleExpiration.Builder.() -> kotlin.Unit) {
            this.expiration = aws.sdk.kotlin.services.s3control.model.LifecycleExpiration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter] inside the given [block]
         */
        fun filter(block: aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.s3control.model.LifecycleRuleFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.NoncurrentVersionExpiration] inside the given [block]
         */
        fun noncurrentVersionExpiration(block: aws.sdk.kotlin.services.s3control.model.NoncurrentVersionExpiration.Builder.() -> kotlin.Unit) {
            this.noncurrentVersionExpiration = aws.sdk.kotlin.services.s3control.model.NoncurrentVersionExpiration.invoke(block)
        }
    }
}
