// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



class ListJobsRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID associated with the S3 Batch Operations job.
     */
    val accountId: kotlin.String? = builder.accountId
    /**
     * The `List Jobs` request returns jobs that match the statuses listed in this element.
     */
    val jobStatuses: List<JobStatus>? = builder.jobStatuses
    /**
     * The maximum number of jobs that Amazon S3 will include in the `List Jobs` response. If there are more jobs than this number, the response will include a pagination token in the `NextToken` field to enable you to retrieve the next page of results.
     */
    val maxResults: kotlin.Int = builder.maxResults
    /**
     * A pagination token to request the next page of results. Use the token that Amazon S3 returned in the `NextToken` element of the `ListJobsResult` from the previous `List Jobs` request.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.ListJobsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListJobsRequest(")
        append("accountId=$accountId,")
        append("jobStatuses=$jobStatuses,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (jobStatuses?.hashCode() ?: 0)
        result = 31 * result + (maxResults)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListJobsRequest

        if (accountId != other.accountId) return false
        if (jobStatuses != other.jobStatuses) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.ListJobsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services account ID associated with the S3 Batch Operations job.
         */
        var accountId: kotlin.String? = null
        /**
         * The `List Jobs` request returns jobs that match the statuses listed in this element.
         */
        var jobStatuses: List<JobStatus>? = null
        /**
         * The maximum number of jobs that Amazon S3 will include in the `List Jobs` response. If there are more jobs than this number, the response will include a pagination token in the `NextToken` field to enable you to retrieve the next page of results.
         */
        var maxResults: kotlin.Int = 0
        /**
         * A pagination token to request the next page of results. Use the token that Amazon S3 returned in the `NextToken` element of the `ListJobsResult` from the previous `List Jobs` request.
         */
        var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.ListJobsRequest) : this() {
            this.accountId = x.accountId
            this.jobStatuses = x.jobStatuses
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.ListJobsRequest = ListJobsRequest(this)
    }
}
