// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * A container for the bucket where the Amazon S3 Storage Lens metrics export files are located.
 */
class S3BucketDestination private constructor(builder: Builder) {
    /**
     * The account ID of the owner of the S3 Storage Lens metrics export bucket.
     */
    val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following format: ` arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> `
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The container for the type encryption of the metrics exports in this bucket.
     */
    val encryption: aws.sdk.kotlin.services.s3control.model.StorageLensDataExportEncryption? = builder.encryption
    /**
     *
     */
    val format: aws.sdk.kotlin.services.s3control.model.Format? = builder.format
    /**
     * The schema version of the export file.
     */
    val outputSchemaVersion: aws.sdk.kotlin.services.s3control.model.OutputSchemaVersion? = builder.outputSchemaVersion
    /**
     * The prefix of the destination bucket where the metrics export will be delivered.
     */
    val prefix: kotlin.String? = builder.prefix

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.S3BucketDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3BucketDestination(")
        append("accountId=$accountId,")
        append("arn=$arn,")
        append("encryption=$encryption,")
        append("format=$format,")
        append("outputSchemaVersion=$outputSchemaVersion,")
        append("prefix=$prefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (outputSchemaVersion?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3BucketDestination

        if (accountId != other.accountId) return false
        if (arn != other.arn) return false
        if (encryption != other.encryption) return false
        if (format != other.format) return false
        if (outputSchemaVersion != other.outputSchemaVersion) return false
        if (prefix != other.prefix) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.S3BucketDestination = Builder(this).apply(block).build()

    class Builder {
        /**
         * The account ID of the owner of the S3 Storage Lens metrics export bucket.
         */
        var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the bucket. This property is read-only and follows the following format: ` arn:aws:s3:<i>us-east-1</i>:<i>example-account-id</i>:bucket/<i>your-destination-bucket-name</i> `
         */
        var arn: kotlin.String? = null
        /**
         * The container for the type encryption of the metrics exports in this bucket.
         */
        var encryption: aws.sdk.kotlin.services.s3control.model.StorageLensDataExportEncryption? = null
        /**
         *
         */
        var format: aws.sdk.kotlin.services.s3control.model.Format? = null
        /**
         * The schema version of the export file.
         */
        var outputSchemaVersion: aws.sdk.kotlin.services.s3control.model.OutputSchemaVersion? = null
        /**
         * The prefix of the destination bucket where the metrics export will be delivered.
         */
        var prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.S3BucketDestination) : this() {
            this.accountId = x.accountId
            this.arn = x.arn
            this.encryption = x.encryption
            this.format = x.format
            this.outputSchemaVersion = x.outputSchemaVersion
            this.prefix = x.prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.S3BucketDestination = S3BucketDestination(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.StorageLensDataExportEncryption] inside the given [block]
         */
        fun encryption(block: aws.sdk.kotlin.services.s3control.model.StorageLensDataExportEncryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.s3control.model.StorageLensDataExportEncryption.invoke(block)
        }
    }
}
