// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the configuration parameters for a PUT Copy object operation. S3 Batch Operations passes every object to the underlying PUT Copy object API. For more information about the parameters for this operation, see [PUT Object - Copy](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectCOPY.html).
 */
class S3CopyObjectOperation private constructor(builder: Builder) {
    /**
     *
     */
    val accessControlGrants: List<S3Grant>? = builder.accessControlGrants
    /**
     * Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Amazon Web Services KMS (SSE-KMS). Setting this header to `true` causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.
     *
     * Specifying this header with an *object* action doesn’t affect *bucket-level* settings for S3 Bucket Key.
     */
    val bucketKeyEnabled: kotlin.Boolean = builder.bucketKeyEnabled
    /**
     *
     */
    val cannedAccessControlList: aws.sdk.kotlin.services.s3control.model.S3CannedAccessControlList? = builder.cannedAccessControlList
    /**
     * Indicates the algorithm you want Amazon S3 to use to create the checksum. For more information see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CheckingObjectIntegrity.xml) in the *Amazon S3 User Guide*.
     */
    val checksumAlgorithm: aws.sdk.kotlin.services.s3control.model.S3ChecksumAlgorithm? = builder.checksumAlgorithm
    /**
     *
     */
    val metadataDirective: aws.sdk.kotlin.services.s3control.model.S3MetadataDirective? = builder.metadataDirective
    /**
     *
     */
    val modifiedSinceConstraint: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedSinceConstraint
    /**
     * If you don't provide this parameter, Amazon S3 copies all the metadata from the original objects. If you specify an empty set, the new objects will have no tags. Otherwise, Amazon S3 assigns the supplied tags to the new objects.
     */
    val newObjectMetadata: aws.sdk.kotlin.services.s3control.model.S3ObjectMetadata? = builder.newObjectMetadata
    /**
     *
     */
    val newObjectTagging: List<S3Tag>? = builder.newObjectTagging
    /**
     * The legal hold status to be applied to all objects in the Batch Operations job.
     */
    val objectLockLegalHoldStatus: aws.sdk.kotlin.services.s3control.model.S3ObjectLockLegalHoldStatus? = builder.objectLockLegalHoldStatus
    /**
     * The retention mode to be applied to all objects in the Batch Operations job.
     */
    val objectLockMode: aws.sdk.kotlin.services.s3control.model.S3ObjectLockMode? = builder.objectLockMode
    /**
     * The date when the applied object retention configuration expires on all objects in the Batch Operations job.
     */
    val objectLockRetainUntilDate: aws.smithy.kotlin.runtime.time.Instant? = builder.objectLockRetainUntilDate
    /**
     * Specifies an optional metadata property for website redirects, `x-amz-website-redirect-location`. Allows webpage redirects if the object is accessed through a website endpoint.
     */
    val redirectLocation: kotlin.String? = builder.redirectLocation
    /**
     *
     */
    val requesterPays: kotlin.Boolean = builder.requesterPays
    /**
     *
     */
    val sseAwsKmsKeyId: kotlin.String? = builder.sseAwsKmsKeyId
    /**
     *
     */
    val storageClass: aws.sdk.kotlin.services.s3control.model.S3StorageClass? = builder.storageClass
    /**
     * Specifies the folder prefix into which you would like the objects to be copied. For example, to copy objects into a folder named `Folder1` in the destination bucket, set the TargetKeyPrefix to `Folder1`.
     */
    val targetKeyPrefix: kotlin.String? = builder.targetKeyPrefix
    /**
     * Specifies the destination bucket ARN for the batch copy operation. For example, to copy objects to a bucket named "destinationBucket", set the TargetResource to "arn:aws:s3:::destinationBucket".
     */
    val targetResource: kotlin.String? = builder.targetResource
    /**
     *
     */
    val unModifiedSinceConstraint: aws.smithy.kotlin.runtime.time.Instant? = builder.unModifiedSinceConstraint

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3CopyObjectOperation(")
        append("accessControlGrants=$accessControlGrants,")
        append("bucketKeyEnabled=$bucketKeyEnabled,")
        append("cannedAccessControlList=$cannedAccessControlList,")
        append("checksumAlgorithm=$checksumAlgorithm,")
        append("metadataDirective=$metadataDirective,")
        append("modifiedSinceConstraint=$modifiedSinceConstraint,")
        append("newObjectMetadata=$newObjectMetadata,")
        append("newObjectTagging=$newObjectTagging,")
        append("objectLockLegalHoldStatus=$objectLockLegalHoldStatus,")
        append("objectLockMode=$objectLockMode,")
        append("objectLockRetainUntilDate=$objectLockRetainUntilDate,")
        append("redirectLocation=$redirectLocation,")
        append("requesterPays=$requesterPays,")
        append("sseAwsKmsKeyId=$sseAwsKmsKeyId,")
        append("storageClass=$storageClass,")
        append("targetKeyPrefix=$targetKeyPrefix,")
        append("targetResource=$targetResource,")
        append("unModifiedSinceConstraint=$unModifiedSinceConstraint)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessControlGrants?.hashCode() ?: 0
        result = 31 * result + (bucketKeyEnabled.hashCode())
        result = 31 * result + (cannedAccessControlList?.hashCode() ?: 0)
        result = 31 * result + (checksumAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (metadataDirective?.hashCode() ?: 0)
        result = 31 * result + (modifiedSinceConstraint?.hashCode() ?: 0)
        result = 31 * result + (newObjectMetadata?.hashCode() ?: 0)
        result = 31 * result + (newObjectTagging?.hashCode() ?: 0)
        result = 31 * result + (objectLockLegalHoldStatus?.hashCode() ?: 0)
        result = 31 * result + (objectLockMode?.hashCode() ?: 0)
        result = 31 * result + (objectLockRetainUntilDate?.hashCode() ?: 0)
        result = 31 * result + (redirectLocation?.hashCode() ?: 0)
        result = 31 * result + (requesterPays.hashCode())
        result = 31 * result + (sseAwsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        result = 31 * result + (targetKeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (targetResource?.hashCode() ?: 0)
        result = 31 * result + (unModifiedSinceConstraint?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3CopyObjectOperation

        if (accessControlGrants != other.accessControlGrants) return false
        if (bucketKeyEnabled != other.bucketKeyEnabled) return false
        if (cannedAccessControlList != other.cannedAccessControlList) return false
        if (checksumAlgorithm != other.checksumAlgorithm) return false
        if (metadataDirective != other.metadataDirective) return false
        if (modifiedSinceConstraint != other.modifiedSinceConstraint) return false
        if (newObjectMetadata != other.newObjectMetadata) return false
        if (newObjectTagging != other.newObjectTagging) return false
        if (objectLockLegalHoldStatus != other.objectLockLegalHoldStatus) return false
        if (objectLockMode != other.objectLockMode) return false
        if (objectLockRetainUntilDate != other.objectLockRetainUntilDate) return false
        if (redirectLocation != other.redirectLocation) return false
        if (requesterPays != other.requesterPays) return false
        if (sseAwsKmsKeyId != other.sseAwsKmsKeyId) return false
        if (storageClass != other.storageClass) return false
        if (targetKeyPrefix != other.targetKeyPrefix) return false
        if (targetResource != other.targetResource) return false
        if (unModifiedSinceConstraint != other.unModifiedSinceConstraint) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation = Builder(this).apply(block).build()

    class Builder {
        /**
         *
         */
        var accessControlGrants: List<S3Grant>? = null
        /**
         * Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using Amazon Web Services KMS (SSE-KMS). Setting this header to `true` causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.
         *
         * Specifying this header with an *object* action doesn’t affect *bucket-level* settings for S3 Bucket Key.
         */
        var bucketKeyEnabled: kotlin.Boolean = false
        /**
         *
         */
        var cannedAccessControlList: aws.sdk.kotlin.services.s3control.model.S3CannedAccessControlList? = null
        /**
         * Indicates the algorithm you want Amazon S3 to use to create the checksum. For more information see [ Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CheckingObjectIntegrity.xml) in the *Amazon S3 User Guide*.
         */
        var checksumAlgorithm: aws.sdk.kotlin.services.s3control.model.S3ChecksumAlgorithm? = null
        /**
         *
         */
        var metadataDirective: aws.sdk.kotlin.services.s3control.model.S3MetadataDirective? = null
        /**
         *
         */
        var modifiedSinceConstraint: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If you don't provide this parameter, Amazon S3 copies all the metadata from the original objects. If you specify an empty set, the new objects will have no tags. Otherwise, Amazon S3 assigns the supplied tags to the new objects.
         */
        var newObjectMetadata: aws.sdk.kotlin.services.s3control.model.S3ObjectMetadata? = null
        /**
         *
         */
        var newObjectTagging: List<S3Tag>? = null
        /**
         * The legal hold status to be applied to all objects in the Batch Operations job.
         */
        var objectLockLegalHoldStatus: aws.sdk.kotlin.services.s3control.model.S3ObjectLockLegalHoldStatus? = null
        /**
         * The retention mode to be applied to all objects in the Batch Operations job.
         */
        var objectLockMode: aws.sdk.kotlin.services.s3control.model.S3ObjectLockMode? = null
        /**
         * The date when the applied object retention configuration expires on all objects in the Batch Operations job.
         */
        var objectLockRetainUntilDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies an optional metadata property for website redirects, `x-amz-website-redirect-location`. Allows webpage redirects if the object is accessed through a website endpoint.
         */
        var redirectLocation: kotlin.String? = null
        /**
         *
         */
        var requesterPays: kotlin.Boolean = false
        /**
         *
         */
        var sseAwsKmsKeyId: kotlin.String? = null
        /**
         *
         */
        var storageClass: aws.sdk.kotlin.services.s3control.model.S3StorageClass? = null
        /**
         * Specifies the folder prefix into which you would like the objects to be copied. For example, to copy objects into a folder named `Folder1` in the destination bucket, set the TargetKeyPrefix to `Folder1`.
         */
        var targetKeyPrefix: kotlin.String? = null
        /**
         * Specifies the destination bucket ARN for the batch copy operation. For example, to copy objects to a bucket named "destinationBucket", set the TargetResource to "arn:aws:s3:::destinationBucket".
         */
        var targetResource: kotlin.String? = null
        /**
         *
         */
        var unModifiedSinceConstraint: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation) : this() {
            this.accessControlGrants = x.accessControlGrants
            this.bucketKeyEnabled = x.bucketKeyEnabled
            this.cannedAccessControlList = x.cannedAccessControlList
            this.checksumAlgorithm = x.checksumAlgorithm
            this.metadataDirective = x.metadataDirective
            this.modifiedSinceConstraint = x.modifiedSinceConstraint
            this.newObjectMetadata = x.newObjectMetadata
            this.newObjectTagging = x.newObjectTagging
            this.objectLockLegalHoldStatus = x.objectLockLegalHoldStatus
            this.objectLockMode = x.objectLockMode
            this.objectLockRetainUntilDate = x.objectLockRetainUntilDate
            this.redirectLocation = x.redirectLocation
            this.requesterPays = x.requesterPays
            this.sseAwsKmsKeyId = x.sseAwsKmsKeyId
            this.storageClass = x.storageClass
            this.targetKeyPrefix = x.targetKeyPrefix
            this.targetResource = x.targetResource
            this.unModifiedSinceConstraint = x.unModifiedSinceConstraint
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation = S3CopyObjectOperation(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3ObjectMetadata] inside the given [block]
         */
        fun newObjectMetadata(block: aws.sdk.kotlin.services.s3control.model.S3ObjectMetadata.Builder.() -> kotlin.Unit) {
            this.newObjectMetadata = aws.sdk.kotlin.services.s3control.model.S3ObjectMetadata.invoke(block)
        }
    }
}
