// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * The container for the service that will create the S3 manifest.
 */
class S3JobManifestGenerator private constructor(builder: Builder) {
    /**
     * Determines whether or not to write the job's generated manifest to a bucket.
     */
    val enableManifestOutput: kotlin.Boolean = builder.enableManifestOutput
    /**
     * The Amazon Web Services account ID that owns the bucket the generated manifest is written to. If provided the generated manifest bucket's owner Amazon Web Services account ID must match this value, else the job fails.
     */
    val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * Specifies rules the S3JobManifestGenerator should use to use to decide whether an object in the source bucket should or should not be included in the generated job manifest.
     */
    val filter: aws.sdk.kotlin.services.s3control.model.JobManifestGeneratorFilter? = builder.filter
    /**
     * Specifies the location the generated manifest will be written to.
     */
    val manifestOutputLocation: aws.sdk.kotlin.services.s3control.model.S3ManifestOutputLocation? = builder.manifestOutputLocation
    /**
     * The source bucket used by the ManifestGenerator.
     */
    val sourceBucket: kotlin.String? = builder.sourceBucket

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.S3JobManifestGenerator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3JobManifestGenerator(")
        append("enableManifestOutput=$enableManifestOutput,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("filter=$filter,")
        append("manifestOutputLocation=$manifestOutputLocation,")
        append("sourceBucket=$sourceBucket)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableManifestOutput.hashCode()
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (manifestOutputLocation?.hashCode() ?: 0)
        result = 31 * result + (sourceBucket?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3JobManifestGenerator

        if (enableManifestOutput != other.enableManifestOutput) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (filter != other.filter) return false
        if (manifestOutputLocation != other.manifestOutputLocation) return false
        if (sourceBucket != other.sourceBucket) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.S3JobManifestGenerator = Builder(this).apply(block).build()

    class Builder {
        /**
         * Determines whether or not to write the job's generated manifest to a bucket.
         */
        var enableManifestOutput: kotlin.Boolean = false
        /**
         * The Amazon Web Services account ID that owns the bucket the generated manifest is written to. If provided the generated manifest bucket's owner Amazon Web Services account ID must match this value, else the job fails.
         */
        var expectedBucketOwner: kotlin.String? = null
        /**
         * Specifies rules the S3JobManifestGenerator should use to use to decide whether an object in the source bucket should or should not be included in the generated job manifest.
         */
        var filter: aws.sdk.kotlin.services.s3control.model.JobManifestGeneratorFilter? = null
        /**
         * Specifies the location the generated manifest will be written to.
         */
        var manifestOutputLocation: aws.sdk.kotlin.services.s3control.model.S3ManifestOutputLocation? = null
        /**
         * The source bucket used by the ManifestGenerator.
         */
        var sourceBucket: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.S3JobManifestGenerator) : this() {
            this.enableManifestOutput = x.enableManifestOutput
            this.expectedBucketOwner = x.expectedBucketOwner
            this.filter = x.filter
            this.manifestOutputLocation = x.manifestOutputLocation
            this.sourceBucket = x.sourceBucket
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.S3JobManifestGenerator = S3JobManifestGenerator(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.JobManifestGeneratorFilter] inside the given [block]
         */
        fun filter(block: aws.sdk.kotlin.services.s3control.model.JobManifestGeneratorFilter.Builder.() -> kotlin.Unit) {
            this.filter = aws.sdk.kotlin.services.s3control.model.JobManifestGeneratorFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3ManifestOutputLocation] inside the given [block]
         */
        fun manifestOutputLocation(block: aws.sdk.kotlin.services.s3control.model.S3ManifestOutputLocation.Builder.() -> kotlin.Unit) {
            this.manifestOutputLocation = aws.sdk.kotlin.services.s3control.model.S3ManifestOutputLocation.invoke(block)
        }
    }
}
