// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.paginators

import aws.sdk.kotlin.services.s3control.S3ControlClient
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsForObjectLambdaRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsForObjectLambdaResponse
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsRequest
import aws.sdk.kotlin.services.s3control.model.ListAccessPointsResponse
import aws.sdk.kotlin.services.s3control.model.ListJobsRequest
import aws.sdk.kotlin.services.s3control.model.ListJobsResponse
import aws.sdk.kotlin.services.s3control.model.ListMultiRegionAccessPointsRequest
import aws.sdk.kotlin.services.s3control.model.ListMultiRegionAccessPointsResponse
import aws.sdk.kotlin.services.s3control.model.ListRegionalBucketsRequest
import aws.sdk.kotlin.services.s3control.model.ListRegionalBucketsResponse
import aws.sdk.kotlin.services.s3control.model.ListStorageLensConfigurationsRequest
import aws.sdk.kotlin.services.s3control.model.ListStorageLensConfigurationsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListAccessPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessPointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPointsResponse]
 */
fun S3ControlClient.listAccessPointsPaginated(initialRequest: ListAccessPointsRequest): Flow<ListAccessPointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessPointsPaginated.listAccessPoints(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPointsResponse]
 */
fun S3ControlClient.listAccessPointsPaginated(block: ListAccessPointsRequest.Builder.() -> Unit): Flow<ListAccessPointsResponse> =
    listAccessPointsPaginated(ListAccessPointsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAccessPointsForObjectLambdaResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessPointsForObjectLambdaRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPointsForObjectLambdaResponse]
 */
fun S3ControlClient.listAccessPointsForObjectLambdaPaginated(initialRequest: ListAccessPointsForObjectLambdaRequest): Flow<ListAccessPointsForObjectLambdaResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessPointsForObjectLambdaPaginated.listAccessPointsForObjectLambda(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessPointsForObjectLambdaResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessPointsForObjectLambdaResponse]
 */
fun S3ControlClient.listAccessPointsForObjectLambdaPaginated(block: ListAccessPointsForObjectLambdaRequest.Builder.() -> Unit): Flow<ListAccessPointsForObjectLambdaResponse> =
    listAccessPointsForObjectLambdaPaginated(ListAccessPointsForObjectLambdaRequest.Builder().apply(block).build())

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
fun S3ControlClient.listJobsPaginated(initialRequest: ListJobsRequest): Flow<ListJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJobsPaginated.listJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
fun S3ControlClient.listJobsPaginated(block: ListJobsRequest.Builder.() -> Unit): Flow<ListJobsResponse> =
    listJobsPaginated(ListJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListMultiRegionAccessPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMultiRegionAccessPointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMultiRegionAccessPointsResponse]
 */
fun S3ControlClient.listMultiRegionAccessPointsPaginated(initialRequest: ListMultiRegionAccessPointsRequest): Flow<ListMultiRegionAccessPointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMultiRegionAccessPointsPaginated.listMultiRegionAccessPoints(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMultiRegionAccessPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMultiRegionAccessPointsResponse]
 */
fun S3ControlClient.listMultiRegionAccessPointsPaginated(block: ListMultiRegionAccessPointsRequest.Builder.() -> Unit): Flow<ListMultiRegionAccessPointsResponse> =
    listMultiRegionAccessPointsPaginated(ListMultiRegionAccessPointsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRegionalBucketsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRegionalBucketsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRegionalBucketsResponse]
 */
fun S3ControlClient.listRegionalBucketsPaginated(initialRequest: ListRegionalBucketsRequest): Flow<ListRegionalBucketsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRegionalBucketsPaginated.listRegionalBuckets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRegionalBucketsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRegionalBucketsResponse]
 */
fun S3ControlClient.listRegionalBucketsPaginated(block: ListRegionalBucketsRequest.Builder.() -> Unit): Flow<ListRegionalBucketsResponse> =
    listRegionalBucketsPaginated(ListRegionalBucketsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListStorageLensConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStorageLensConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStorageLensConfigurationsResponse]
 */
fun S3ControlClient.listStorageLensConfigurationsPaginated(initialRequest: ListStorageLensConfigurationsRequest): Flow<ListStorageLensConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStorageLensConfigurationsPaginated.listStorageLensConfigurations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListStorageLensConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStorageLensConfigurationsResponse]
 */
fun S3ControlClient.listStorageLensConfigurationsPaginated(block: ListStorageLensConfigurationsRequest.Builder.() -> Unit): Flow<ListStorageLensConfigurationsResponse> =
    listStorageLensConfigurationsPaginated(ListStorageLensConfigurationsRequest.Builder().apply(block).build())
