// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A container for the information about an asynchronous operation.
 */
public class AsyncOperation private constructor(builder: Builder) {
    /**
     * The time that the request was sent to the service.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The specific operation for the asynchronous request.
     */
    public val operation: aws.sdk.kotlin.services.s3control.model.AsyncOperationName? = builder.operation
    /**
     * The parameters associated with the request.
     */
    public val requestParameters: aws.sdk.kotlin.services.s3control.model.AsyncRequestParameters? = builder.requestParameters
    /**
     * The current status of the request.
     */
    public val requestStatus: kotlin.String? = builder.requestStatus
    /**
     * The request token associated with the request.
     */
    public val requestTokenArn: kotlin.String? = builder.requestTokenArn
    /**
     * The details of the response.
     */
    public val responseDetails: aws.sdk.kotlin.services.s3control.model.AsyncResponseDetails? = builder.responseDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.AsyncOperation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AsyncOperation(")
        append("creationTime=$creationTime,")
        append("operation=$operation,")
        append("requestParameters=$requestParameters,")
        append("requestStatus=$requestStatus,")
        append("requestTokenArn=$requestTokenArn,")
        append("responseDetails=$responseDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (operation?.hashCode() ?: 0)
        result = 31 * result + (requestParameters?.hashCode() ?: 0)
        result = 31 * result + (requestStatus?.hashCode() ?: 0)
        result = 31 * result + (requestTokenArn?.hashCode() ?: 0)
        result = 31 * result + (responseDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AsyncOperation

        if (creationTime != other.creationTime) return false
        if (operation != other.operation) return false
        if (requestParameters != other.requestParameters) return false
        if (requestStatus != other.requestStatus) return false
        if (requestTokenArn != other.requestTokenArn) return false
        if (responseDetails != other.responseDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.AsyncOperation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time that the request was sent to the service.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The specific operation for the asynchronous request.
         */
        public var operation: aws.sdk.kotlin.services.s3control.model.AsyncOperationName? = null
        /**
         * The parameters associated with the request.
         */
        public var requestParameters: aws.sdk.kotlin.services.s3control.model.AsyncRequestParameters? = null
        /**
         * The current status of the request.
         */
        public var requestStatus: kotlin.String? = null
        /**
         * The request token associated with the request.
         */
        public var requestTokenArn: kotlin.String? = null
        /**
         * The details of the response.
         */
        public var responseDetails: aws.sdk.kotlin.services.s3control.model.AsyncResponseDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.AsyncOperation) : this() {
            this.creationTime = x.creationTime
            this.operation = x.operation
            this.requestParameters = x.requestParameters
            this.requestStatus = x.requestStatus
            this.requestTokenArn = x.requestTokenArn
            this.responseDetails = x.responseDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.AsyncOperation = AsyncOperation(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.AsyncRequestParameters] inside the given [block]
         */
        public fun requestParameters(block: aws.sdk.kotlin.services.s3control.model.AsyncRequestParameters.Builder.() -> kotlin.Unit) {
            this.requestParameters = aws.sdk.kotlin.services.s3control.model.AsyncRequestParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.AsyncResponseDetails] inside the given [block]
         */
        public fun responseDetails(block: aws.sdk.kotlin.services.s3control.model.AsyncResponseDetails.Builder.() -> kotlin.Unit) {
            this.responseDetails = aws.sdk.kotlin.services.s3control.model.AsyncResponseDetails.invoke(block)
        }
    }
}
