// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



public class CreateJobRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID that creates the job.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * An idempotency token to ensure that you don't accidentally submit the same request twice. You can use any string up to the maximum length.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console.
     */
    public val confirmationRequired: kotlin.Boolean? = builder.confirmationRequired
    /**
     * A description for this job. You can use any string within the permitted length. Descriptions don't need to be unique and can be used for multiple jobs.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Configuration parameters for the manifest.
     */
    public val manifest: aws.sdk.kotlin.services.s3control.model.JobManifest? = builder.manifest
    /**
     * The attribute container for the ManifestGenerator details. Jobs must be created with either a manifest file or a ManifestGenerator, but not both.
     */
    public val manifestGenerator: aws.sdk.kotlin.services.s3control.model.JobManifestGenerator? = builder.manifestGenerator
    /**
     * The action that you want this job to perform on every object listed in the manifest. For more information about the available actions, see [Operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html) in the *Amazon S3 User Guide*.
     */
    public val operation: aws.sdk.kotlin.services.s3control.model.JobOperation? = builder.operation
    /**
     * The numerical priority for this job. Higher numbers indicate higher priority.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * Configuration parameters for the optional job-completion report.
     */
    public val report: aws.sdk.kotlin.services.s3control.model.JobReport? = builder.report
    /**
     * The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role that Batch Operations will use to run this job's action on every object in the manifest.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A set of tags to associate with the S3 Batch Operations job. This is an optional parameter.
     */
    public val tags: List<S3Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.CreateJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateJobRequest(")
        append("accountId=$accountId,")
        append("clientRequestToken=$clientRequestToken,")
        append("confirmationRequired=$confirmationRequired,")
        append("description=$description,")
        append("manifest=$manifest,")
        append("manifestGenerator=$manifestGenerator,")
        append("operation=$operation,")
        append("priority=$priority,")
        append("report=$report,")
        append("roleArn=$roleArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (confirmationRequired?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (manifest?.hashCode() ?: 0)
        result = 31 * result + (manifestGenerator?.hashCode() ?: 0)
        result = 31 * result + (operation?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (report?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateJobRequest

        if (accountId != other.accountId) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (confirmationRequired != other.confirmationRequired) return false
        if (description != other.description) return false
        if (manifest != other.manifest) return false
        if (manifestGenerator != other.manifestGenerator) return false
        if (operation != other.operation) return false
        if (priority != other.priority) return false
        if (report != other.report) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.CreateJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID that creates the job.
         */
        public var accountId: kotlin.String? = null
        /**
         * An idempotency token to ensure that you don't accidentally submit the same request twice. You can use any string up to the maximum length.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * Indicates whether confirmation is required before Amazon S3 runs the job. Confirmation is only required for jobs created through the Amazon S3 console.
         */
        public var confirmationRequired: kotlin.Boolean? = null
        /**
         * A description for this job. You can use any string within the permitted length. Descriptions don't need to be unique and can be used for multiple jobs.
         */
        public var description: kotlin.String? = null
        /**
         * Configuration parameters for the manifest.
         */
        public var manifest: aws.sdk.kotlin.services.s3control.model.JobManifest? = null
        /**
         * The attribute container for the ManifestGenerator details. Jobs must be created with either a manifest file or a ManifestGenerator, but not both.
         */
        public var manifestGenerator: aws.sdk.kotlin.services.s3control.model.JobManifestGenerator? = null
        /**
         * The action that you want this job to perform on every object listed in the manifest. For more information about the available actions, see [Operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-actions.html) in the *Amazon S3 User Guide*.
         */
        public var operation: aws.sdk.kotlin.services.s3control.model.JobOperation? = null
        /**
         * The numerical priority for this job. Higher numbers indicate higher priority.
         */
        public var priority: kotlin.Int? = null
        /**
         * Configuration parameters for the optional job-completion report.
         */
        public var report: aws.sdk.kotlin.services.s3control.model.JobReport? = null
        /**
         * The Amazon Resource Name (ARN) for the Identity and Access Management (IAM) role that Batch Operations will use to run this job's action on every object in the manifest.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A set of tags to associate with the S3 Batch Operations job. This is an optional parameter.
         */
        public var tags: List<S3Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.CreateJobRequest) : this() {
            this.accountId = x.accountId
            this.clientRequestToken = x.clientRequestToken
            this.confirmationRequired = x.confirmationRequired
            this.description = x.description
            this.manifest = x.manifest
            this.manifestGenerator = x.manifestGenerator
            this.operation = x.operation
            this.priority = x.priority
            this.report = x.report
            this.roleArn = x.roleArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.CreateJobRequest = CreateJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.JobManifest] inside the given [block]
         */
        public fun manifest(block: aws.sdk.kotlin.services.s3control.model.JobManifest.Builder.() -> kotlin.Unit) {
            this.manifest = aws.sdk.kotlin.services.s3control.model.JobManifest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.JobOperation] inside the given [block]
         */
        public fun operation(block: aws.sdk.kotlin.services.s3control.model.JobOperation.Builder.() -> kotlin.Unit) {
            this.operation = aws.sdk.kotlin.services.s3control.model.JobOperation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.JobReport] inside the given [block]
         */
        public fun report(block: aws.sdk.kotlin.services.s3control.model.JobReport.Builder.() -> kotlin.Unit) {
            this.report = aws.sdk.kotlin.services.s3control.model.JobReport.invoke(block)
        }
    }
}
