// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the configuration and status information for a single job retrieved as part of a job list.
 */
public class JobListDescriptor private constructor(builder: Builder) {
    /**
     * A timestamp indicating when the specified job was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The user-specified description that was included in the specified job's `Create Job` request.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID for the specified job.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The operation that the specified job is configured to run on every object listed in the manifest.
     */
    public val operation: aws.sdk.kotlin.services.s3control.model.OperationName? = builder.operation
    /**
     * The current priority for the specified job.
     */
    public val priority: kotlin.Int = builder.priority
    /**
     * Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.
     */
    public val progressSummary: aws.sdk.kotlin.services.s3control.model.JobProgressSummary? = builder.progressSummary
    /**
     * The specified job's current status.
     */
    public val status: aws.sdk.kotlin.services.s3control.model.JobStatus? = builder.status
    /**
     * A timestamp indicating when the specified job terminated. A job's termination date is the date and time when it succeeded, failed, or was canceled.
     */
    public val terminationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.terminationDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.JobListDescriptor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobListDescriptor(")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("jobId=$jobId,")
        append("operation=$operation,")
        append("priority=$priority,")
        append("progressSummary=$progressSummary,")
        append("status=$status,")
        append("terminationDate=$terminationDate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (operation?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (progressSummary?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (terminationDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobListDescriptor

        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (jobId != other.jobId) return false
        if (operation != other.operation) return false
        if (priority != other.priority) return false
        if (progressSummary != other.progressSummary) return false
        if (status != other.status) return false
        if (terminationDate != other.terminationDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.JobListDescriptor = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A timestamp indicating when the specified job was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user-specified description that was included in the specified job's `Create Job` request.
         */
        public var description: kotlin.String? = null
        /**
         * The ID for the specified job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The operation that the specified job is configured to run on every object listed in the manifest.
         */
        public var operation: aws.sdk.kotlin.services.s3control.model.OperationName? = null
        /**
         * The current priority for the specified job.
         */
        public var priority: kotlin.Int = 0
        /**
         * Describes the total number of tasks that the specified job has run, the number of tasks that succeeded, and the number of tasks that failed.
         */
        public var progressSummary: aws.sdk.kotlin.services.s3control.model.JobProgressSummary? = null
        /**
         * The specified job's current status.
         */
        public var status: aws.sdk.kotlin.services.s3control.model.JobStatus? = null
        /**
         * A timestamp indicating when the specified job terminated. A job's termination date is the date and time when it succeeded, failed, or was canceled.
         */
        public var terminationDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.JobListDescriptor) : this() {
            this.creationTime = x.creationTime
            this.description = x.description
            this.jobId = x.jobId
            this.operation = x.operation
            this.priority = x.priority
            this.progressSummary = x.progressSummary
            this.status = x.status
            this.terminationDate = x.terminationDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.JobListDescriptor = JobListDescriptor(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.JobProgressSummary] inside the given [block]
         */
        public fun progressSummary(block: aws.sdk.kotlin.services.s3control.model.JobProgressSummary.Builder.() -> kotlin.Unit) {
            this.progressSummary = aws.sdk.kotlin.services.s3control.model.JobProgressSummary.invoke(block)
        }
    }
}
