// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.transform

import aws.sdk.kotlin.services.s3control.model.CreateAccessPointRequest
import aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration
import aws.sdk.kotlin.services.s3control.model.VpcConfiguration
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer


internal class CreateAccessPointOperationSerializer: HttpSerialize<CreateAccessPointRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateAccessPointRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "v20180820",
                "accesspoint",
                "${input.name}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        builder.headers {
            if (input.accountId?.isNotEmpty() == true) append("x-amz-account-id", input.accountId)
        }

        val payload = serializeCreateAccessPointOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}

private fun serializeCreateAccessPointOperationBody(context: ExecutionContext, input: CreateAccessPointRequest): ByteArray {
    val serializer = XmlSerializer()
    val BUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Bucket"))
    val PUBLICACCESSBLOCKCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("PublicAccessBlockConfiguration"))
    val VPCCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("VpcConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateAccessPointRequest"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(BUCKET_DESCRIPTOR)
        field(PUBLICACCESSBLOCKCONFIGURATION_DESCRIPTOR)
        field(VPCCONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.bucket?.let { field(BUCKET_DESCRIPTOR, it) }
        input.publicAccessBlockConfiguration?.let { field(PUBLICACCESSBLOCKCONFIGURATION_DESCRIPTOR, it, ::serializePublicAccessBlockConfigurationDocument) }
        input.vpcConfiguration?.let { field(VPCCONFIGURATION_DESCRIPTOR, it, ::serializeVpcConfigurationDocument) }
    }
    return serializer.toByteArray()
}
