// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.endpoints



/**
 * The set of values necessary for endpoint resolution.
 */
public class EndpointParameters private constructor(builder: Builder) {
    /**
     * The S3 AccessPointName used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 AccessPoint.
     */
    public val accessPointName: String? = builder.accessPointName

    /**
     * The Account ID used to send the request. This is an optional parameter that will be set automatically for operations that require it.
     */
    public val accountId: String? = builder.accountId

    /**
     * The S3 bucket used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 bucket.
     */
    public val bucket: String? = builder.bucket

    /**
     * Override the endpoint used to send this request
     */
    public val endpoint: String? = builder.endpoint

    /**
     * The Outpost ID.  Some operations have an optional OutpostId which should be used in endpoint construction.
     */
    public val outpostId: String? = builder.outpostId

    /**
     * The AWS region used to dispatch the request.
     */
    public val region: String? = builder.region

    /**
     * Internal parameter for operations that require account id host prefix.
     */
    public val requiresAccountId: Boolean? = builder.requiresAccountId

    /**
     * When an Access Point ARN is provided and this flag is enabled, the SDK MUST use the ARN's region when constructing the endpoint instead of the client's configured region.
     */
    public val useArnRegion: Boolean? = builder.useArnRegion

    /**
     * When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
     */
    public val useDualStack: Boolean? = requireNotNull(builder.useDualStack) { "endpoint provider parameter #useDualStack is required" }

    /**
     * When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
     */
    public val useFips: Boolean? = requireNotNull(builder.useFips) { "endpoint provider parameter #useFips is required" }

    public companion object {
        public inline operator fun invoke(block: Builder.() -> Unit): EndpointParameters = Builder().apply(block).build()
    }

    public override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is EndpointParameters) return false
        if (this.accessPointName != other.accessPointName) return false
        if (this.accountId != other.accountId) return false
        if (this.bucket != other.bucket) return false
        if (this.endpoint != other.endpoint) return false
        if (this.outpostId != other.outpostId) return false
        if (this.region != other.region) return false
        if (this.requiresAccountId != other.requiresAccountId) return false
        if (this.useArnRegion != other.useArnRegion) return false
        if (this.useDualStack != other.useDualStack) return false
        if (this.useFips != other.useFips) return false
        return true
    }

    public override fun hashCode(): Int {
        var result = accessPointName?.hashCode() ?: 0
        result = 31 * result + (accountId?.hashCode() ?: 0)
        result = 31 * result + (bucket?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (outpostId?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (requiresAccountId?.hashCode() ?: 0)
        result = 31 * result + (useArnRegion?.hashCode() ?: 0)
        result = 31 * result + (useDualStack?.hashCode() ?: 0)
        result = 31 * result + (useFips?.hashCode() ?: 0)
        return result
    }

    public override fun toString(): String = buildString {
        append("EndpointParameters(")
        append("accessPointName=$accessPointName,")
        append("accountId=$accountId,")
        append("bucket=$bucket,")
        append("endpoint=$endpoint,")
        append("outpostId=$outpostId,")
        append("region=$region,")
        append("requiresAccountId=$requiresAccountId,")
        append("useArnRegion=$useArnRegion,")
        append("useDualStack=$useDualStack,")
        append("useFips=$useFips)")
    }

    public fun copy(block: Builder.() -> Unit = {}): EndpointParameters {
        return Builder().apply {
            accessPointName = this@EndpointParameters.accessPointName
            accountId = this@EndpointParameters.accountId
            bucket = this@EndpointParameters.bucket
            endpoint = this@EndpointParameters.endpoint
            outpostId = this@EndpointParameters.outpostId
            region = this@EndpointParameters.region
            requiresAccountId = this@EndpointParameters.requiresAccountId
            useArnRegion = this@EndpointParameters.useArnRegion
            useDualStack = this@EndpointParameters.useDualStack
            useFips = this@EndpointParameters.useFips
            block()
        }
        .build()
    }

    public class Builder {
        /**
         * The S3 AccessPointName used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 AccessPoint.
         */
        public var accessPointName: String? = null

        /**
         * The Account ID used to send the request. This is an optional parameter that will be set automatically for operations that require it.
         */
        public var accountId: String? = null

        /**
         * The S3 bucket used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 bucket.
         */
        public var bucket: String? = null

        /**
         * Override the endpoint used to send this request
         */
        public var endpoint: String? = null

        /**
         * The Outpost ID.  Some operations have an optional OutpostId which should be used in endpoint construction.
         */
        public var outpostId: String? = null

        /**
         * The AWS region used to dispatch the request.
         */
        public var region: String? = null

        /**
         * Internal parameter for operations that require account id host prefix.
         */
        public var requiresAccountId: Boolean? = null

        /**
         * When an Access Point ARN is provided and this flag is enabled, the SDK MUST use the ARN's region when constructing the endpoint instead of the client's configured region.
         */
        public var useArnRegion: Boolean? = null

        /**
         * When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.
         */
        public var useDualStack: Boolean? = false

        /**
         * When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.
         */
        public var useFips: Boolean? = false

        public fun build(): EndpointParameters = EndpointParameters(this)
    }
}
