// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * A container for the account-level Amazon S3 Storage Lens configuration.
 *
 * For more information about S3 Storage Lens, see [Assessing your storage activity and usage with S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the *Amazon S3 User Guide*. For a complete list of S3 Storage Lens metrics, see [S3 Storage Lens metrics glossary](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens_metrics_glossary.html) in the *Amazon S3 User Guide*.
 */
public class AccountLevel private constructor(builder: Builder) {
    /**
     * A container for S3 Storage Lens activity metrics.
     */
    public val activityMetrics: aws.sdk.kotlin.services.s3control.model.ActivityMetrics? = builder.activityMetrics
    /**
     * A container for S3 Storage Lens advanced cost-optimization metrics.
     */
    public val advancedCostOptimizationMetrics: aws.sdk.kotlin.services.s3control.model.AdvancedCostOptimizationMetrics? = builder.advancedCostOptimizationMetrics
    /**
     * A container for S3 Storage Lens advanced data-protection metrics.
     */
    public val advancedDataProtectionMetrics: aws.sdk.kotlin.services.s3control.model.AdvancedDataProtectionMetrics? = builder.advancedDataProtectionMetrics
    /**
     * A container for the S3 Storage Lens bucket-level configuration.
     */
    public val bucketLevel: aws.sdk.kotlin.services.s3control.model.BucketLevel? = builder.bucketLevel
    /**
     * A container for detailed status code metrics.
     */
    public val detailedStatusCodesMetrics: aws.sdk.kotlin.services.s3control.model.DetailedStatusCodesMetrics? = builder.detailedStatusCodesMetrics

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.AccountLevel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountLevel(")
        append("activityMetrics=$activityMetrics,")
        append("advancedCostOptimizationMetrics=$advancedCostOptimizationMetrics,")
        append("advancedDataProtectionMetrics=$advancedDataProtectionMetrics,")
        append("bucketLevel=$bucketLevel,")
        append("detailedStatusCodesMetrics=$detailedStatusCodesMetrics)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityMetrics?.hashCode() ?: 0
        result = 31 * result + (advancedCostOptimizationMetrics?.hashCode() ?: 0)
        result = 31 * result + (advancedDataProtectionMetrics?.hashCode() ?: 0)
        result = 31 * result + (bucketLevel?.hashCode() ?: 0)
        result = 31 * result + (detailedStatusCodesMetrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountLevel

        if (activityMetrics != other.activityMetrics) return false
        if (advancedCostOptimizationMetrics != other.advancedCostOptimizationMetrics) return false
        if (advancedDataProtectionMetrics != other.advancedDataProtectionMetrics) return false
        if (bucketLevel != other.bucketLevel) return false
        if (detailedStatusCodesMetrics != other.detailedStatusCodesMetrics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.AccountLevel = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A container for S3 Storage Lens activity metrics.
         */
        public var activityMetrics: aws.sdk.kotlin.services.s3control.model.ActivityMetrics? = null
        /**
         * A container for S3 Storage Lens advanced cost-optimization metrics.
         */
        public var advancedCostOptimizationMetrics: aws.sdk.kotlin.services.s3control.model.AdvancedCostOptimizationMetrics? = null
        /**
         * A container for S3 Storage Lens advanced data-protection metrics.
         */
        public var advancedDataProtectionMetrics: aws.sdk.kotlin.services.s3control.model.AdvancedDataProtectionMetrics? = null
        /**
         * A container for the S3 Storage Lens bucket-level configuration.
         */
        public var bucketLevel: aws.sdk.kotlin.services.s3control.model.BucketLevel? = null
        /**
         * A container for detailed status code metrics.
         */
        public var detailedStatusCodesMetrics: aws.sdk.kotlin.services.s3control.model.DetailedStatusCodesMetrics? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.AccountLevel) : this() {
            this.activityMetrics = x.activityMetrics
            this.advancedCostOptimizationMetrics = x.advancedCostOptimizationMetrics
            this.advancedDataProtectionMetrics = x.advancedDataProtectionMetrics
            this.bucketLevel = x.bucketLevel
            this.detailedStatusCodesMetrics = x.detailedStatusCodesMetrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.AccountLevel = AccountLevel(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.ActivityMetrics] inside the given [block]
         */
        public fun activityMetrics(block: aws.sdk.kotlin.services.s3control.model.ActivityMetrics.Builder.() -> kotlin.Unit) {
            this.activityMetrics = aws.sdk.kotlin.services.s3control.model.ActivityMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.AdvancedCostOptimizationMetrics] inside the given [block]
         */
        public fun advancedCostOptimizationMetrics(block: aws.sdk.kotlin.services.s3control.model.AdvancedCostOptimizationMetrics.Builder.() -> kotlin.Unit) {
            this.advancedCostOptimizationMetrics = aws.sdk.kotlin.services.s3control.model.AdvancedCostOptimizationMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.AdvancedDataProtectionMetrics] inside the given [block]
         */
        public fun advancedDataProtectionMetrics(block: aws.sdk.kotlin.services.s3control.model.AdvancedDataProtectionMetrics.Builder.() -> kotlin.Unit) {
            this.advancedDataProtectionMetrics = aws.sdk.kotlin.services.s3control.model.AdvancedDataProtectionMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.BucketLevel] inside the given [block]
         */
        public fun bucketLevel(block: aws.sdk.kotlin.services.s3control.model.BucketLevel.Builder.() -> kotlin.Unit) {
            this.bucketLevel = aws.sdk.kotlin.services.s3control.model.BucketLevel.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.DetailedStatusCodesMetrics] inside the given [block]
         */
        public fun detailedStatusCodesMetrics(block: aws.sdk.kotlin.services.s3control.model.DetailedStatusCodesMetrics.Builder.() -> kotlin.Unit) {
            this.detailedStatusCodesMetrics = aws.sdk.kotlin.services.s3control.model.DetailedStatusCodesMetrics.invoke(block)
        }
    }
}
