// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * The operation that you want this job to perform on every object listed in the manifest. For more information about the available operations, see [Operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-operations.html) in the *Amazon S3 User Guide*.
 */
public class JobOperation private constructor(builder: Builder) {
    /**
     * Directs the specified job to invoke an Lambda function on every object in the manifest.
     */
    public val lambdaInvoke: aws.sdk.kotlin.services.s3control.model.LambdaInvokeOperation? = builder.lambdaInvoke
    /**
     * Directs the specified job to execute a DELETE Object tagging call on every object in the manifest.
     */
    public val s3DeleteObjectTagging: aws.sdk.kotlin.services.s3control.model.S3DeleteObjectTaggingOperation? = builder.s3DeleteObjectTagging
    /**
     * Directs the specified job to initiate restore requests for every archived object in the manifest.
     */
    public val s3InitiateRestoreObject: aws.sdk.kotlin.services.s3control.model.S3InitiateRestoreObjectOperation? = builder.s3InitiateRestoreObject
    /**
     * Directs the specified job to run a `PutObjectAcl` call on every object in the manifest.
     */
    public val s3PutObjectAcl: aws.sdk.kotlin.services.s3control.model.S3SetObjectAclOperation? = builder.s3PutObjectAcl
    /**
     * Directs the specified job to run a PUT Copy object call on every object in the manifest.
     */
    public val s3PutObjectCopy: aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation? = builder.s3PutObjectCopy
    /**
     * Contains the configuration for an S3 Object Lock legal hold operation that an S3 Batch Operations job passes every object to the underlying `PutObjectLegalHold` API. For more information, see [Using S3 Object Lock legal hold with S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html) in the *Amazon S3 User Guide*.
     */
    public val s3PutObjectLegalHold: aws.sdk.kotlin.services.s3control.model.S3SetObjectLegalHoldOperation? = builder.s3PutObjectLegalHold
    /**
     * Contains the configuration parameters for the Object Lock retention action for an S3 Batch Operations job. Batch Operations passes every object to the underlying `PutObjectRetention` API. For more information, see [Using S3 Object Lock retention with S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html) in the *Amazon S3 User Guide*.
     */
    public val s3PutObjectRetention: aws.sdk.kotlin.services.s3control.model.S3SetObjectRetentionOperation? = builder.s3PutObjectRetention
    /**
     * Directs the specified job to run a PUT Object tagging call on every object in the manifest.
     */
    public val s3PutObjectTagging: aws.sdk.kotlin.services.s3control.model.S3SetObjectTaggingOperation? = builder.s3PutObjectTagging
    /**
     * Directs the specified job to invoke `ReplicateObject` on every object in the job's manifest.
     */
    public val s3ReplicateObject: aws.sdk.kotlin.services.s3control.model.S3ReplicateObjectOperation? = builder.s3ReplicateObject

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.JobOperation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobOperation(")
        append("lambdaInvoke=$lambdaInvoke,")
        append("s3DeleteObjectTagging=$s3DeleteObjectTagging,")
        append("s3InitiateRestoreObject=$s3InitiateRestoreObject,")
        append("s3PutObjectAcl=$s3PutObjectAcl,")
        append("s3PutObjectCopy=$s3PutObjectCopy,")
        append("s3PutObjectLegalHold=$s3PutObjectLegalHold,")
        append("s3PutObjectRetention=$s3PutObjectRetention,")
        append("s3PutObjectTagging=$s3PutObjectTagging,")
        append("s3ReplicateObject=$s3ReplicateObject)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lambdaInvoke?.hashCode() ?: 0
        result = 31 * result + (s3DeleteObjectTagging?.hashCode() ?: 0)
        result = 31 * result + (s3InitiateRestoreObject?.hashCode() ?: 0)
        result = 31 * result + (s3PutObjectAcl?.hashCode() ?: 0)
        result = 31 * result + (s3PutObjectCopy?.hashCode() ?: 0)
        result = 31 * result + (s3PutObjectLegalHold?.hashCode() ?: 0)
        result = 31 * result + (s3PutObjectRetention?.hashCode() ?: 0)
        result = 31 * result + (s3PutObjectTagging?.hashCode() ?: 0)
        result = 31 * result + (s3ReplicateObject?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobOperation

        if (lambdaInvoke != other.lambdaInvoke) return false
        if (s3DeleteObjectTagging != other.s3DeleteObjectTagging) return false
        if (s3InitiateRestoreObject != other.s3InitiateRestoreObject) return false
        if (s3PutObjectAcl != other.s3PutObjectAcl) return false
        if (s3PutObjectCopy != other.s3PutObjectCopy) return false
        if (s3PutObjectLegalHold != other.s3PutObjectLegalHold) return false
        if (s3PutObjectRetention != other.s3PutObjectRetention) return false
        if (s3PutObjectTagging != other.s3PutObjectTagging) return false
        if (s3ReplicateObject != other.s3ReplicateObject) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.JobOperation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Directs the specified job to invoke an Lambda function on every object in the manifest.
         */
        public var lambdaInvoke: aws.sdk.kotlin.services.s3control.model.LambdaInvokeOperation? = null
        /**
         * Directs the specified job to execute a DELETE Object tagging call on every object in the manifest.
         */
        public var s3DeleteObjectTagging: aws.sdk.kotlin.services.s3control.model.S3DeleteObjectTaggingOperation? = null
        /**
         * Directs the specified job to initiate restore requests for every archived object in the manifest.
         */
        public var s3InitiateRestoreObject: aws.sdk.kotlin.services.s3control.model.S3InitiateRestoreObjectOperation? = null
        /**
         * Directs the specified job to run a `PutObjectAcl` call on every object in the manifest.
         */
        public var s3PutObjectAcl: aws.sdk.kotlin.services.s3control.model.S3SetObjectAclOperation? = null
        /**
         * Directs the specified job to run a PUT Copy object call on every object in the manifest.
         */
        public var s3PutObjectCopy: aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation? = null
        /**
         * Contains the configuration for an S3 Object Lock legal hold operation that an S3 Batch Operations job passes every object to the underlying `PutObjectLegalHold` API. For more information, see [Using S3 Object Lock legal hold with S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-legal-hold.html) in the *Amazon S3 User Guide*.
         */
        public var s3PutObjectLegalHold: aws.sdk.kotlin.services.s3control.model.S3SetObjectLegalHoldOperation? = null
        /**
         * Contains the configuration parameters for the Object Lock retention action for an S3 Batch Operations job. Batch Operations passes every object to the underlying `PutObjectRetention` API. For more information, see [Using S3 Object Lock retention with S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-retention-date.html) in the *Amazon S3 User Guide*.
         */
        public var s3PutObjectRetention: aws.sdk.kotlin.services.s3control.model.S3SetObjectRetentionOperation? = null
        /**
         * Directs the specified job to run a PUT Object tagging call on every object in the manifest.
         */
        public var s3PutObjectTagging: aws.sdk.kotlin.services.s3control.model.S3SetObjectTaggingOperation? = null
        /**
         * Directs the specified job to invoke `ReplicateObject` on every object in the job's manifest.
         */
        public var s3ReplicateObject: aws.sdk.kotlin.services.s3control.model.S3ReplicateObjectOperation? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.JobOperation) : this() {
            this.lambdaInvoke = x.lambdaInvoke
            this.s3DeleteObjectTagging = x.s3DeleteObjectTagging
            this.s3InitiateRestoreObject = x.s3InitiateRestoreObject
            this.s3PutObjectAcl = x.s3PutObjectAcl
            this.s3PutObjectCopy = x.s3PutObjectCopy
            this.s3PutObjectLegalHold = x.s3PutObjectLegalHold
            this.s3PutObjectRetention = x.s3PutObjectRetention
            this.s3PutObjectTagging = x.s3PutObjectTagging
            this.s3ReplicateObject = x.s3ReplicateObject
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.JobOperation = JobOperation(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.LambdaInvokeOperation] inside the given [block]
         */
        public fun lambdaInvoke(block: aws.sdk.kotlin.services.s3control.model.LambdaInvokeOperation.Builder.() -> kotlin.Unit) {
            this.lambdaInvoke = aws.sdk.kotlin.services.s3control.model.LambdaInvokeOperation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3DeleteObjectTaggingOperation] inside the given [block]
         */
        public fun s3DeleteObjectTagging(block: aws.sdk.kotlin.services.s3control.model.S3DeleteObjectTaggingOperation.Builder.() -> kotlin.Unit) {
            this.s3DeleteObjectTagging = aws.sdk.kotlin.services.s3control.model.S3DeleteObjectTaggingOperation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3InitiateRestoreObjectOperation] inside the given [block]
         */
        public fun s3InitiateRestoreObject(block: aws.sdk.kotlin.services.s3control.model.S3InitiateRestoreObjectOperation.Builder.() -> kotlin.Unit) {
            this.s3InitiateRestoreObject = aws.sdk.kotlin.services.s3control.model.S3InitiateRestoreObjectOperation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3SetObjectAclOperation] inside the given [block]
         */
        public fun s3PutObjectAcl(block: aws.sdk.kotlin.services.s3control.model.S3SetObjectAclOperation.Builder.() -> kotlin.Unit) {
            this.s3PutObjectAcl = aws.sdk.kotlin.services.s3control.model.S3SetObjectAclOperation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation] inside the given [block]
         */
        public fun s3PutObjectCopy(block: aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation.Builder.() -> kotlin.Unit) {
            this.s3PutObjectCopy = aws.sdk.kotlin.services.s3control.model.S3CopyObjectOperation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3SetObjectLegalHoldOperation] inside the given [block]
         */
        public fun s3PutObjectLegalHold(block: aws.sdk.kotlin.services.s3control.model.S3SetObjectLegalHoldOperation.Builder.() -> kotlin.Unit) {
            this.s3PutObjectLegalHold = aws.sdk.kotlin.services.s3control.model.S3SetObjectLegalHoldOperation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3SetObjectRetentionOperation] inside the given [block]
         */
        public fun s3PutObjectRetention(block: aws.sdk.kotlin.services.s3control.model.S3SetObjectRetentionOperation.Builder.() -> kotlin.Unit) {
            this.s3PutObjectRetention = aws.sdk.kotlin.services.s3control.model.S3SetObjectRetentionOperation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3SetObjectTaggingOperation] inside the given [block]
         */
        public fun s3PutObjectTagging(block: aws.sdk.kotlin.services.s3control.model.S3SetObjectTaggingOperation.Builder.() -> kotlin.Unit) {
            this.s3PutObjectTagging = aws.sdk.kotlin.services.s3control.model.S3SetObjectTaggingOperation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3control.model.S3ReplicateObjectOperation] inside the given [block]
         */
        public fun s3ReplicateObject(block: aws.sdk.kotlin.services.s3control.model.S3ReplicateObjectOperation.Builder.() -> kotlin.Unit) {
            this.s3ReplicateObject = aws.sdk.kotlin.services.s3control.model.S3ReplicateObjectOperation.invoke(block)
        }
    }
}
