// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.s3control.model.GetAccessPointResponse
import aws.sdk.kotlin.services.s3control.model.NetworkOrigin
import aws.sdk.kotlin.services.s3control.model.PublicAccessBlockConfiguration
import aws.sdk.kotlin.services.s3control.model.S3ControlException
import aws.sdk.kotlin.services.s3control.model.VpcConfiguration
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class GetAccessPointOperationDeserializer: HttpDeserialize<GetAccessPointResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetAccessPointResponse {
        if (!response.status.isSuccess()) {
            throwGetAccessPointError(context, response)
        }
        val builder = GetAccessPointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAccessPointOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetAccessPointError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw S3ControlException("Failed to parse response as 'restXml' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3ControlException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAccessPointOperationBody(builder: GetAccessPointResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val ACCESSPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("AccessPointArn"))
    val ALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Alias"))
    val BUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Bucket"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, XmlSerialName("CreationDate"))
    val ENDPOINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, XmlSerialName("Endpoints"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Name"))
    val NETWORKORIGIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("NetworkOrigin"))
    val PUBLICACCESSBLOCKCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("PublicAccessBlockConfiguration"))
    val VPCCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("VpcConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("GetAccessPointResult"))
        trait(XmlNamespace("http://awss3control.amazonaws.com/doc/2018-08-20/"))
        field(ACCESSPOINTARN_DESCRIPTOR)
        field(ALIAS_DESCRIPTOR)
        field(BUCKET_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(ENDPOINTS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(NETWORKORIGIN_DESCRIPTOR)
        field(PUBLICACCESSBLOCKCONFIGURATION_DESCRIPTOR)
        field(VPCCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSPOINTARN_DESCRIPTOR.index -> builder.accessPointArn = deserializeString()
                ALIAS_DESCRIPTOR.index -> builder.alias = deserializeString()
                BUCKET_DESCRIPTOR.index -> builder.bucket = deserializeString()
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromIso8601(it) }
                ENDPOINTS_DESCRIPTOR.index -> builder.endpoints =
                    deserializer.deserializeMap(ENDPOINTS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                NETWORKORIGIN_DESCRIPTOR.index -> builder.networkOrigin = deserializeString().let { NetworkOrigin.fromValue(it) }
                PUBLICACCESSBLOCKCONFIGURATION_DESCRIPTOR.index -> builder.publicAccessBlockConfiguration = deserializePublicAccessBlockConfigurationDocument(deserializer)
                VPCCONFIGURATION_DESCRIPTOR.index -> builder.vpcConfiguration = deserializeVpcConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
