// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3control.model



/**
 * Contains the configuration parameters for an S3 Initiate Restore Object job. S3 Batch Operations passes every object to the underlying POST Object restore API. For more information about the parameters for this operation, see [RestoreObject](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html#RESTObjectPOSTrestore-restore-request).
 */
public class S3InitiateRestoreObjectOperation private constructor(builder: Builder) {
    /**
     * This argument specifies how long the S3 Glacier or S3 Glacier Deep Archive object remains available in Amazon S3. S3 Initiate Restore Object jobs that target S3 Glacier and S3 Glacier Deep Archive objects require `ExpirationInDays` set to 1 or greater.
     *
     * Conversely, do *not* set `ExpirationInDays` when creating S3 Initiate Restore Object jobs that target S3 Intelligent-Tiering Archive Access and Deep Archive Access tier objects. Objects in S3 Intelligent-Tiering archive access tiers are not subject to restore expiry, so specifying `ExpirationInDays` results in restore request failure.
     *
     * S3 Batch Operations jobs can operate either on S3 Glacier and S3 Glacier Deep Archive storage class objects or on S3 Intelligent-Tiering Archive Access and Deep Archive Access storage tier objects, but not both types in the same job. If you need to restore objects of both types you *must* create separate Batch Operations jobs.
     */
    public val expirationInDays: kotlin.Int? = builder.expirationInDays
    /**
     * S3 Batch Operations supports `STANDARD` and `BULK` retrieval tiers, but not the `EXPEDITED` retrieval tier.
     */
    public val glacierJobTier: aws.sdk.kotlin.services.s3control.model.S3GlacierJobTier? = builder.glacierJobTier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3control.model.S3InitiateRestoreObjectOperation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3InitiateRestoreObjectOperation(")
        append("expirationInDays=$expirationInDays,")
        append("glacierJobTier=$glacierJobTier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = expirationInDays ?: 0
        result = 31 * result + (glacierJobTier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3InitiateRestoreObjectOperation

        if (expirationInDays != other.expirationInDays) return false
        if (glacierJobTier != other.glacierJobTier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3control.model.S3InitiateRestoreObjectOperation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This argument specifies how long the S3 Glacier or S3 Glacier Deep Archive object remains available in Amazon S3. S3 Initiate Restore Object jobs that target S3 Glacier and S3 Glacier Deep Archive objects require `ExpirationInDays` set to 1 or greater.
         *
         * Conversely, do *not* set `ExpirationInDays` when creating S3 Initiate Restore Object jobs that target S3 Intelligent-Tiering Archive Access and Deep Archive Access tier objects. Objects in S3 Intelligent-Tiering archive access tiers are not subject to restore expiry, so specifying `ExpirationInDays` results in restore request failure.
         *
         * S3 Batch Operations jobs can operate either on S3 Glacier and S3 Glacier Deep Archive storage class objects or on S3 Intelligent-Tiering Archive Access and Deep Archive Access storage tier objects, but not both types in the same job. If you need to restore objects of both types you *must* create separate Batch Operations jobs.
         */
        public var expirationInDays: kotlin.Int? = null
        /**
         * S3 Batch Operations supports `STANDARD` and `BULK` retrieval tiers, but not the `EXPEDITED` retrieval tier.
         */
        public var glacierJobTier: aws.sdk.kotlin.services.s3control.model.S3GlacierJobTier? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3control.model.S3InitiateRestoreObjectOperation) : this() {
            this.expirationInDays = x.expirationInDays
            this.glacierJobTier = x.glacierJobTier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3control.model.S3InitiateRestoreObjectOperation = S3InitiateRestoreObjectOperation(this)
    }
}
