// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3outposts.model



public class CreateEndpointRequest private constructor(builder: Builder) {
    /**
     * The type of access for the network connectivity for the Amazon S3 on Outposts endpoint. To use the Amazon Web Services VPC, choose `Private`. To use the endpoint with an on-premises network, choose `CustomerOwnedIp`. If you choose `CustomerOwnedIp`, you must also provide the customer-owned IP address pool (CoIP pool).
     *
     * `Private` is the default access type value.
     */
    public val accessType: aws.sdk.kotlin.services.s3outposts.model.EndpointAccessType? = builder.accessType
    /**
     * The ID of the customer-owned IPv4 address pool (CoIP pool) for the endpoint. IP addresses are allocated from this pool for the endpoint.
     */
    public val customerOwnedIpv4Pool: kotlin.String? = builder.customerOwnedIpv4Pool
    /**
     * The ID of the Outposts.
     */
    public val outpostId: kotlin.String? = builder.outpostId
    /**
     * The ID of the security group to use with the endpoint.
     */
    public val securityGroupId: kotlin.String? = builder.securityGroupId
    /**
     * The ID of the subnet in the selected VPC. The endpoint subnet must belong to the Outpost that has Amazon S3 on Outposts provisioned.
     */
    public val subnetId: kotlin.String? = builder.subnetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3outposts.model.CreateEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEndpointRequest(")
        append("accessType=$accessType,")
        append("customerOwnedIpv4Pool=$customerOwnedIpv4Pool,")
        append("outpostId=$outpostId,")
        append("securityGroupId=$securityGroupId,")
        append("subnetId=$subnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessType?.hashCode() ?: 0
        result = 31 * result + (customerOwnedIpv4Pool?.hashCode() ?: 0)
        result = 31 * result + (outpostId?.hashCode() ?: 0)
        result = 31 * result + (securityGroupId?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEndpointRequest

        if (accessType != other.accessType) return false
        if (customerOwnedIpv4Pool != other.customerOwnedIpv4Pool) return false
        if (outpostId != other.outpostId) return false
        if (securityGroupId != other.securityGroupId) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3outposts.model.CreateEndpointRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of access for the network connectivity for the Amazon S3 on Outposts endpoint. To use the Amazon Web Services VPC, choose `Private`. To use the endpoint with an on-premises network, choose `CustomerOwnedIp`. If you choose `CustomerOwnedIp`, you must also provide the customer-owned IP address pool (CoIP pool).
         *
         * `Private` is the default access type value.
         */
        public var accessType: aws.sdk.kotlin.services.s3outposts.model.EndpointAccessType? = null
        /**
         * The ID of the customer-owned IPv4 address pool (CoIP pool) for the endpoint. IP addresses are allocated from this pool for the endpoint.
         */
        public var customerOwnedIpv4Pool: kotlin.String? = null
        /**
         * The ID of the Outposts.
         */
        public var outpostId: kotlin.String? = null
        /**
         * The ID of the security group to use with the endpoint.
         */
        public var securityGroupId: kotlin.String? = null
        /**
         * The ID of the subnet in the selected VPC. The endpoint subnet must belong to the Outpost that has Amazon S3 on Outposts provisioned.
         */
        public var subnetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3outposts.model.CreateEndpointRequest) : this() {
            this.accessType = x.accessType
            this.customerOwnedIpv4Pool = x.customerOwnedIpv4Pool
            this.outpostId = x.outpostId
            this.securityGroupId = x.securityGroupId
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3outposts.model.CreateEndpointRequest = CreateEndpointRequest(this)
    }
}
