// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3outposts.paginators

import aws.sdk.kotlin.services.s3outposts.S3OutpostsClient
import aws.sdk.kotlin.services.s3outposts.model.Endpoint
import aws.sdk.kotlin.services.s3outposts.model.ListEndpointsRequest
import aws.sdk.kotlin.services.s3outposts.model.ListEndpointsResponse
import aws.sdk.kotlin.services.s3outposts.model.ListSharedEndpointsRequest
import aws.sdk.kotlin.services.s3outposts.model.ListSharedEndpointsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEndpointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEndpointsResponse]
 */
public fun S3OutpostsClient.listEndpointsPaginated(initialRequest: ListEndpointsRequest): Flow<ListEndpointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEndpointsPaginated.listEndpoints(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEndpointsResponse]
 */
public fun S3OutpostsClient.listEndpointsPaginated(block: ListEndpointsRequest.Builder.() -> Unit): Flow<ListEndpointsResponse> =
    listEndpointsPaginated(ListEndpointsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEndpointsPaginated]
 * to access the nested member [Endpoint]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Endpoint]
 */
@JvmName("listEndpointsResponseEndpoint")
public fun Flow<ListEndpointsResponse>.endpoints(): Flow<Endpoint> =
    transform() { response ->
        response.endpoints?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSharedEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSharedEndpointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSharedEndpointsResponse]
 */
public fun S3OutpostsClient.listSharedEndpointsPaginated(initialRequest: ListSharedEndpointsRequest): Flow<ListSharedEndpointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSharedEndpointsPaginated.listSharedEndpoints(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSharedEndpointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSharedEndpointsResponse]
 */
public fun S3OutpostsClient.listSharedEndpointsPaginated(block: ListSharedEndpointsRequest.Builder.() -> Unit): Flow<ListSharedEndpointsResponse> =
    listSharedEndpointsPaginated(ListSharedEndpointsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSharedEndpointsPaginated]
 * to access the nested member [Endpoint]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Endpoint]
 */
@JvmName("listSharedEndpointsResponseEndpoint")
public fun Flow<ListSharedEndpointsResponse>.endpoints(): Flow<Endpoint> =
    transform() { response ->
        response.endpoints?.forEach {
            emit(it)
        }
    }
