// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies the training algorithm to use in a CreateTrainingJob request.
 *
 * For more information about algorithms provided by SageMaker, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html). For information about using your own algorithms, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
 */
class AlgorithmSpecification private constructor(builder: Builder) {
    /**
     * The name of the algorithm resource to use for the training job. This must be an algorithm resource that you created or subscribe to on Amazon Web Services Marketplace.
     *
     * You must specify either the algorithm name to the `AlgorithmName` parameter or the image URI of the algorithm container to the `TrainingImage` parameter.
     *
     * Note that the `AlgorithmName` parameter is mutually exclusive with the `TrainingImage` parameter. If you specify a value for the `AlgorithmName` parameter, you can't specify a value for `TrainingImage`, and vice versa.
     *
     * If you specify values for both parameters, the training job might break; if you don't specify any value for both parameters, the training job might raise a `null` error.
     */
    val algorithmName: kotlin.String? = builder.algorithmName
    /**
     * To generate and save time-series metrics during training, set to `true`. The default is `false` and time-series metrics aren't generated except in the following cases:
     * + You use one of the SageMaker built-in algorithms
     * + You use one of the following [Prebuilt SageMaker Docker Images](https://docs.aws.amazon.com/sagemaker/latest/dg/pre-built-containers-frameworks-deep-learning.html):
     *    + Tensorflow (version >= 1.15)
     *    + MXNet (version >= 1.6)
     *    + PyTorch (version >= 1.3)
     * + You specify at least one MetricDefinition
     */
    val enableSageMakerMetricsTimeSeries: kotlin.Boolean = builder.enableSageMakerMetricsTimeSeries
    /**
     * A list of metric definition objects. Each object specifies the metric name and regular expressions used to parse algorithm logs. SageMaker publishes each metric to Amazon CloudWatch.
     */
    val metricDefinitions: List<MetricDefinition>? = builder.metricDefinitions
    /**
     * The registry path of the Docker image that contains the training algorithm. For information about docker registry paths for SageMaker built-in algorithms, see [Docker Registry Paths and Example Code](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html) in the *Amazon SageMaker developer guide*. SageMaker supports both `registry/repository[:tag]` and `registry/repository[@digest]` image path formats. For more information about using your custom training container, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
     *
     * You must specify either the algorithm name to the `AlgorithmName` parameter or the image URI of the algorithm container to the `TrainingImage` parameter.
     *
     * For more information, see the note in the `AlgorithmName` parameter description.
     */
    val trainingImage: kotlin.String? = builder.trainingImage
    /**
     * The training input mode that the algorithm supports. For more information about input modes, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
     *
     * **Pipe mode**
     *
     * If an algorithm supports `Pipe` mode, Amazon SageMaker streams data directly from Amazon S3 to the container.
     *
     * **File mode**
     *
     * If an algorithm supports `File` mode, SageMaker downloads the training data from S3 to the provisioned ML storage volume, and mounts the directory to the Docker volume for the training container.
     *
     * You must provision the ML storage volume with sufficient capacity to accommodate the data downloaded from S3. In addition to the training data, the ML storage volume also stores the output model. The algorithm container uses the ML storage volume to also store intermediate information, if any.
     *
     * For distributed algorithms, training data is distributed uniformly. Your training duration is predictable if the input data objects sizes are approximately the same. SageMaker does not split the files any further for model training. If the object sizes are skewed, training won't be optimal as the data distribution is also skewed when one host in a training cluster is overloaded, thus becoming a bottleneck in training.
     *
     * **FastFile mode**
     *
     * If an algorithm supports `FastFile` mode, SageMaker streams data directly from S3 to the container with no code changes, and provides file system access to the data. Users can author their training script to interact with these files as if they were stored on disk.
     *
     * `FastFile` mode works best when the data is read sequentially. Augmented manifest files aren't supported. The startup time is lower when there are fewer files in the S3 bucket provided.
     */
    val trainingInputMode: aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode? = builder.trainingInputMode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlgorithmSpecification(")
        append("algorithmName=$algorithmName,")
        append("enableSageMakerMetricsTimeSeries=$enableSageMakerMetricsTimeSeries,")
        append("metricDefinitions=$metricDefinitions,")
        append("trainingImage=$trainingImage,")
        append("trainingInputMode=$trainingInputMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithmName?.hashCode() ?: 0
        result = 31 * result + (enableSageMakerMetricsTimeSeries.hashCode())
        result = 31 * result + (metricDefinitions?.hashCode() ?: 0)
        result = 31 * result + (trainingImage?.hashCode() ?: 0)
        result = 31 * result + (trainingInputMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlgorithmSpecification

        if (algorithmName != other.algorithmName) return false
        if (enableSageMakerMetricsTimeSeries != other.enableSageMakerMetricsTimeSeries) return false
        if (metricDefinitions != other.metricDefinitions) return false
        if (trainingImage != other.trainingImage) return false
        if (trainingInputMode != other.trainingInputMode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the algorithm resource to use for the training job. This must be an algorithm resource that you created or subscribe to on Amazon Web Services Marketplace.
         *
         * You must specify either the algorithm name to the `AlgorithmName` parameter or the image URI of the algorithm container to the `TrainingImage` parameter.
         *
         * Note that the `AlgorithmName` parameter is mutually exclusive with the `TrainingImage` parameter. If you specify a value for the `AlgorithmName` parameter, you can't specify a value for `TrainingImage`, and vice versa.
         *
         * If you specify values for both parameters, the training job might break; if you don't specify any value for both parameters, the training job might raise a `null` error.
         */
        var algorithmName: kotlin.String? = null
        /**
         * To generate and save time-series metrics during training, set to `true`. The default is `false` and time-series metrics aren't generated except in the following cases:
         * + You use one of the SageMaker built-in algorithms
         * + You use one of the following [Prebuilt SageMaker Docker Images](https://docs.aws.amazon.com/sagemaker/latest/dg/pre-built-containers-frameworks-deep-learning.html):
         *    + Tensorflow (version >= 1.15)
         *    + MXNet (version >= 1.6)
         *    + PyTorch (version >= 1.3)
         * + You specify at least one MetricDefinition
         */
        var enableSageMakerMetricsTimeSeries: kotlin.Boolean = false
        /**
         * A list of metric definition objects. Each object specifies the metric name and regular expressions used to parse algorithm logs. SageMaker publishes each metric to Amazon CloudWatch.
         */
        var metricDefinitions: List<MetricDefinition>? = null
        /**
         * The registry path of the Docker image that contains the training algorithm. For information about docker registry paths for SageMaker built-in algorithms, see [Docker Registry Paths and Example Code](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html) in the *Amazon SageMaker developer guide*. SageMaker supports both `registry/repository[:tag]` and `registry/repository[@digest]` image path formats. For more information about using your custom training container, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
         *
         * You must specify either the algorithm name to the `AlgorithmName` parameter or the image URI of the algorithm container to the `TrainingImage` parameter.
         *
         * For more information, see the note in the `AlgorithmName` parameter description.
         */
        var trainingImage: kotlin.String? = null
        /**
         * The training input mode that the algorithm supports. For more information about input modes, see [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
         *
         * **Pipe mode**
         *
         * If an algorithm supports `Pipe` mode, Amazon SageMaker streams data directly from Amazon S3 to the container.
         *
         * **File mode**
         *
         * If an algorithm supports `File` mode, SageMaker downloads the training data from S3 to the provisioned ML storage volume, and mounts the directory to the Docker volume for the training container.
         *
         * You must provision the ML storage volume with sufficient capacity to accommodate the data downloaded from S3. In addition to the training data, the ML storage volume also stores the output model. The algorithm container uses the ML storage volume to also store intermediate information, if any.
         *
         * For distributed algorithms, training data is distributed uniformly. Your training duration is predictable if the input data objects sizes are approximately the same. SageMaker does not split the files any further for model training. If the object sizes are skewed, training won't be optimal as the data distribution is also skewed when one host in a training cluster is overloaded, thus becoming a bottleneck in training.
         *
         * **FastFile mode**
         *
         * If an algorithm supports `FastFile` mode, SageMaker streams data directly from S3 to the container with no code changes, and provides file system access to the data. Users can author their training script to interact with these files as if they were stored on disk.
         *
         * `FastFile` mode works best when the data is read sequentially. Augmented manifest files aren't supported. The startup time is lower when there are fewer files in the S3 bucket provided.
         */
        var trainingInputMode: aws.sdk.kotlin.services.sagemaker.model.TrainingInputMode? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification) : this() {
            this.algorithmName = x.algorithmName
            this.enableSageMakerMetricsTimeSeries = x.enableSageMakerMetricsTimeSeries
            this.metricDefinitions = x.metricDefinitions
            this.trainingImage = x.trainingImage
            this.trainingInputMode = x.trainingInputMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AlgorithmSpecification = AlgorithmSpecification(this)
    }
}
