// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Configures how labels are consolidated across human workers and processes output data.
 */
class AnnotationConsolidationConfig private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of a Lambda function implements the logic for [annotation consolidation](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html) and to process output data.
     *
     * This parameter is required for all labeling jobs. For [built-in task types](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html), use one of the following Amazon SageMaker Ground Truth Lambda function ARNs for `AnnotationConsolidationLambdaArn`. For custom labeling workflows, see [Post-annotation Lambda](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-postlambda).
     *
     * **Bounding box** - Finds the most similar boxes from different workers based on the Jaccard index of the boxes.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-BoundingBox`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-BoundingBox`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-BoundingBox`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-BoundingBox`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-BoundingBox`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-BoundingBox`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-BoundingBox`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-BoundingBox`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-BoundingBox`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-BoundingBox`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-BoundingBox`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-BoundingBox`
     *
     * **Image classification** - Uses a variant of the Expectation Maximization approach to estimate the true class of an image based on annotations from individual workers.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClass`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClass`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClass`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClass`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClass`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClass`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClass`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClass`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClass`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClass`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClass`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClass`
     *
     * **Multi-label image classification** - Uses a variant of the Expectation Maximization approach to estimate the true classes of an image based on annotations from individual workers.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClassMultiLabel`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClassMultiLabel`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClassMultiLabel`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClassMultiLabel`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClassMultiLabel`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClassMultiLabel`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClassMultiLabel`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClassMultiLabel`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClassMultiLabel`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClassMultiLabel`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClassMultiLabel`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClassMultiLabel`
     *
     * **Semantic segmentation** - Treats each pixel in an image as a multi-class classification and treats pixel annotations from workers as "votes" for the correct label.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-SemanticSegmentation`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-SemanticSegmentation`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-SemanticSegmentation`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-SemanticSegmentation`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-SemanticSegmentation`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-SemanticSegmentation`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-SemanticSegmentation`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-SemanticSegmentation`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-SemanticSegmentation`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-SemanticSegmentation`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-SemanticSegmentation`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-SemanticSegmentation`
     *
     * **Text classification** - Uses a variant of the Expectation Maximization approach to estimate the true class of text based on annotations from individual workers.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClass`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClass`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClass`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClass`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClass`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClass`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClass`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClass`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClass`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClass`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClass`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClass`
     *
     * **Multi-label text classification** - Uses a variant of the Expectation Maximization approach to estimate the true classes of text based on annotations from individual workers.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClassMultiLabel`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClassMultiLabel`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClassMultiLabel`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClassMultiLabel`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClassMultiLabel`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClassMultiLabel`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClassMultiLabel`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClassMultiLabel`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClassMultiLabel`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClassMultiLabel`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClassMultiLabel`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClassMultiLabel`
     *
     * **Named entity recognition** - Groups similar selections and calculates aggregate boundaries, resolving to most-assigned label.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-NamedEntityRecognition`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-NamedEntityRecognition`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-NamedEntityRecognition`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-NamedEntityRecognition`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-NamedEntityRecognition`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-NamedEntityRecognition`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-NamedEntityRecognition`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-NamedEntityRecognition`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-NamedEntityRecognition`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-NamedEntityRecognition`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-NamedEntityRecognition`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-NamedEntityRecognition`
     *
     * **Video Classification** - Use this task type when you need workers to classify videos using predefined labels that you specify. Workers are shown videos and are asked to choose one label for each video.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoMultiClass`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoMultiClass`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoMultiClass`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoMultiClass`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoMultiClass`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoMultiClass`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoMultiClass`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoMultiClass`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoMultiClass`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoMultiClass`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoMultiClass`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoMultiClass`
     *
     * **Video Frame Object Detection** - Use this task type to have workers identify and locate objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to identify and localize various objects in a series of video frames, such as cars, bikes, and pedestrians.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectDetection`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectDetection`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectDetection`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectDetection`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectDetection`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectDetection`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectDetection`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectDetection`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectDetection`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectDetection`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectDetection`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectDetection`
     *
     * **Video Frame Object Tracking** - Use this task type to have workers track the movement of objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to track the movement of objects, such as cars, bikes, and pedestrians.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectTracking`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectTracking`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectTracking`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectTracking`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectTracking`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectTracking`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectTracking`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectTracking`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectTracking`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectTracking`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectTracking`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectTracking`
     *
     * **3D Point Cloud Object Detection** - Use this task type when you want workers to classify objects in a 3D point cloud by drawing 3D cuboids around objects. For example, you can use this task type to ask workers to identify different types of objects in a point cloud, such as cars, bikes, and pedestrians.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectDetection`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectDetection`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectDetection`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectDetection`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectDetection`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectDetection`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectDetection`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectDetection`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectDetection`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectDetection`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectDetection`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectDetection`
     *
     * **3D Point Cloud Object Tracking** - Use this task type when you want workers to draw 3D cuboids around objects that appear in a sequence of 3D point cloud frames. For example, you can use this task type to ask workers to track the movement of vehicles across multiple point cloud frames.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectTracking`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectTracking`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectTracking`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectTracking`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectTracking`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectTracking`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectTracking`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectTracking`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectTracking`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectTracking`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectTracking`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectTracking`
     *
     * **3D Point Cloud Semantic Segmentation** - Use this task type when you want workers to create a point-level semantic segmentation masks by painting objects in a 3D point cloud using different colors where each color is assigned to one of the classes you specify.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudSemanticSegmentation`
     *
     * **Use the following ARNs for Label Verification and Adjustment Jobs**
     *
     * Use label verification and adjustment jobs to review and adjust labels. To learn more, see [Verify and Adjust Labels ](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html).
     *
     * **Semantic Segmentation Adjustment** - Treats each pixel in an image as a multi-class classification and treats pixel adjusted annotations from workers as "votes" for the correct label.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentSemanticSegmentation`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentSemanticSegmentation`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentSemanticSegmentation`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentSemanticSegmentation`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentSemanticSegmentation`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentSemanticSegmentation`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentSemanticSegmentation`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentSemanticSegmentation`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentSemanticSegmentation`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentSemanticSegmentation`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentSemanticSegmentation`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentSemanticSegmentation`
     *
     * **Semantic Segmentation Verification** - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgment for semantic segmentation labels based on annotations from individual workers.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationSemanticSegmentation`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationSemanticSegmentation`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationSemanticSegmentation`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationSemanticSegmentation`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationSemanticSegmentation`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationSemanticSegmentation`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationSemanticSegmentation`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationSemanticSegmentation`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationSemanticSegmentation`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationSemanticSegmentation`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationSemanticSegmentation`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationSemanticSegmentation`
     *
     * **Bounding Box Adjustment** - Finds the most similar boxes from different workers based on the Jaccard index of the adjusted annotations.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentBoundingBox`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentBoundingBox`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentBoundingBox`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentBoundingBox`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentBoundingBox`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentBoundingBox`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentBoundingBox`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentBoundingBox`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentBoundingBox`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentBoundingBox`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentBoundingBox`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentBoundingBox`
     *
     * **Bounding Box Verification** - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgement for bounding box labels based on annotations from individual workers.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationBoundingBox`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationBoundingBox`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationBoundingBox`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationBoundingBox`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationBoundingBox`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationBoundingBox`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationBoundingBox`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationBoundingBox`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationBoundingBox`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationBoundingBox`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationBoundingBox`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationBoundingBox`
     *
     * **Video Frame Object Detection Adjustment** - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to classify and localize objects in a sequence of video frames.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectDetection`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectDetection`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectDetection`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectDetection`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectDetection`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectDetection`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectDetection`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectDetection`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectDetection`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectDetection`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectDetection`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectDetection`
     *
     * **Video Frame Object Tracking Adjustment** - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to track object movement across a sequence of video frames.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectTracking`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectTracking`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectTracking`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectTracking`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectTracking`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectTracking`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectTracking`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectTracking`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectTracking`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectTracking`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectTracking`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectTracking`
     *
     * **3D Point Cloud Object Detection Adjustment** - Use this task type when you want workers to adjust 3D cuboids around objects in a 3D point cloud.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectDetection`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectDetection`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectDetection`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectDetection`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectDetection`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectDetection`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectDetection`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectDetection`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectDetection`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectDetection`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectDetection`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectDetection`
     *
     * **3D Point Cloud Object Tracking Adjustment** - Use this task type when you want workers to adjust 3D cuboids around objects that appear in a sequence of 3D point cloud frames.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectTracking`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectTracking`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectTracking`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectTracking`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectTracking`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectTracking`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectTracking`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectTracking`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectTracking`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectTracking`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectTracking`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectTracking`
     *
     * **3D Point Cloud Semantic Segmentation Adjustment** - Use this task type when you want workers to adjust a point-level semantic segmentation masks using a paint tool.
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
     * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
     */
    val annotationConsolidationLambdaArn: kotlin.String? = builder.annotationConsolidationLambdaArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AnnotationConsolidationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnnotationConsolidationConfig(")
        append("annotationConsolidationLambdaArn=$annotationConsolidationLambdaArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = annotationConsolidationLambdaArn?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnnotationConsolidationConfig

        if (annotationConsolidationLambdaArn != other.annotationConsolidationLambdaArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AnnotationConsolidationConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of a Lambda function implements the logic for [annotation consolidation](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html) and to process output data.
         *
         * This parameter is required for all labeling jobs. For [built-in task types](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html), use one of the following Amazon SageMaker Ground Truth Lambda function ARNs for `AnnotationConsolidationLambdaArn`. For custom labeling workflows, see [Post-annotation Lambda](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-postlambda).
         *
         * **Bounding box** - Finds the most similar boxes from different workers based on the Jaccard index of the boxes.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-BoundingBox`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-BoundingBox`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-BoundingBox`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-BoundingBox`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-BoundingBox`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-BoundingBox`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-BoundingBox`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-BoundingBox`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-BoundingBox`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-BoundingBox`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-BoundingBox`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-BoundingBox`
         *
         * **Image classification** - Uses a variant of the Expectation Maximization approach to estimate the true class of an image based on annotations from individual workers.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClass`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClass`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClass`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClass`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClass`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClass`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClass`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClass`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClass`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClass`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClass`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClass`
         *
         * **Multi-label image classification** - Uses a variant of the Expectation Maximization approach to estimate the true classes of an image based on annotations from individual workers.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClassMultiLabel`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClassMultiLabel`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClassMultiLabel`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClassMultiLabel`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClassMultiLabel`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClassMultiLabel`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClassMultiLabel`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClassMultiLabel`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClassMultiLabel`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClassMultiLabel`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClassMultiLabel`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClassMultiLabel`
         *
         * **Semantic segmentation** - Treats each pixel in an image as a multi-class classification and treats pixel annotations from workers as "votes" for the correct label.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-SemanticSegmentation`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-SemanticSegmentation`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-SemanticSegmentation`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-SemanticSegmentation`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-SemanticSegmentation`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-SemanticSegmentation`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-SemanticSegmentation`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-SemanticSegmentation`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-SemanticSegmentation`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-SemanticSegmentation`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-SemanticSegmentation`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-SemanticSegmentation`
         *
         * **Text classification** - Uses a variant of the Expectation Maximization approach to estimate the true class of text based on annotations from individual workers.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClass`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClass`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClass`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClass`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClass`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClass`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClass`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClass`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClass`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClass`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClass`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClass`
         *
         * **Multi-label text classification** - Uses a variant of the Expectation Maximization approach to estimate the true classes of text based on annotations from individual workers.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClassMultiLabel`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClassMultiLabel`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClassMultiLabel`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClassMultiLabel`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClassMultiLabel`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClassMultiLabel`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClassMultiLabel`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClassMultiLabel`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClassMultiLabel`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClassMultiLabel`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClassMultiLabel`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClassMultiLabel`
         *
         * **Named entity recognition** - Groups similar selections and calculates aggregate boundaries, resolving to most-assigned label.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-NamedEntityRecognition`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-NamedEntityRecognition`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-NamedEntityRecognition`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-NamedEntityRecognition`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-NamedEntityRecognition`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-NamedEntityRecognition`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-NamedEntityRecognition`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-NamedEntityRecognition`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-NamedEntityRecognition`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-NamedEntityRecognition`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-NamedEntityRecognition`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-NamedEntityRecognition`
         *
         * **Video Classification** - Use this task type when you need workers to classify videos using predefined labels that you specify. Workers are shown videos and are asked to choose one label for each video.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoMultiClass`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoMultiClass`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoMultiClass`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoMultiClass`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoMultiClass`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoMultiClass`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoMultiClass`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoMultiClass`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoMultiClass`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoMultiClass`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoMultiClass`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoMultiClass`
         *
         * **Video Frame Object Detection** - Use this task type to have workers identify and locate objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to identify and localize various objects in a series of video frames, such as cars, bikes, and pedestrians.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectDetection`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectDetection`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectDetection`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectDetection`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectDetection`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectDetection`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectDetection`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectDetection`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectDetection`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectDetection`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectDetection`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectDetection`
         *
         * **Video Frame Object Tracking** - Use this task type to have workers track the movement of objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to track the movement of objects, such as cars, bikes, and pedestrians.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectTracking`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectTracking`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectTracking`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectTracking`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectTracking`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectTracking`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectTracking`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectTracking`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectTracking`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectTracking`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectTracking`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectTracking`
         *
         * **3D Point Cloud Object Detection** - Use this task type when you want workers to classify objects in a 3D point cloud by drawing 3D cuboids around objects. For example, you can use this task type to ask workers to identify different types of objects in a point cloud, such as cars, bikes, and pedestrians.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectDetection`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectDetection`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectDetection`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectDetection`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectDetection`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectDetection`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectDetection`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectDetection`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectDetection`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectDetection`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectDetection`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectDetection`
         *
         * **3D Point Cloud Object Tracking** - Use this task type when you want workers to draw 3D cuboids around objects that appear in a sequence of 3D point cloud frames. For example, you can use this task type to ask workers to track the movement of vehicles across multiple point cloud frames.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectTracking`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectTracking`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectTracking`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectTracking`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectTracking`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectTracking`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectTracking`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectTracking`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectTracking`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectTracking`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectTracking`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectTracking`
         *
         * **3D Point Cloud Semantic Segmentation** - Use this task type when you want workers to create a point-level semantic segmentation masks by painting objects in a 3D point cloud using different colors where each color is assigned to one of the classes you specify.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudSemanticSegmentation`
         *
         * **Use the following ARNs for Label Verification and Adjustment Jobs**
         *
         * Use label verification and adjustment jobs to review and adjust labels. To learn more, see [Verify and Adjust Labels ](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html).
         *
         * **Semantic Segmentation Adjustment** - Treats each pixel in an image as a multi-class classification and treats pixel adjusted annotations from workers as "votes" for the correct label.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentSemanticSegmentation`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentSemanticSegmentation`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentSemanticSegmentation`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentSemanticSegmentation`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentSemanticSegmentation`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentSemanticSegmentation`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentSemanticSegmentation`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentSemanticSegmentation`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentSemanticSegmentation`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentSemanticSegmentation`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentSemanticSegmentation`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentSemanticSegmentation`
         *
         * **Semantic Segmentation Verification** - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgment for semantic segmentation labels based on annotations from individual workers.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationSemanticSegmentation`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationSemanticSegmentation`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationSemanticSegmentation`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationSemanticSegmentation`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationSemanticSegmentation`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationSemanticSegmentation`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationSemanticSegmentation`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationSemanticSegmentation`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationSemanticSegmentation`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationSemanticSegmentation`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationSemanticSegmentation`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationSemanticSegmentation`
         *
         * **Bounding Box Adjustment** - Finds the most similar boxes from different workers based on the Jaccard index of the adjusted annotations.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentBoundingBox`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentBoundingBox`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentBoundingBox`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentBoundingBox`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentBoundingBox`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentBoundingBox`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentBoundingBox`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentBoundingBox`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentBoundingBox`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentBoundingBox`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentBoundingBox`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentBoundingBox`
         *
         * **Bounding Box Verification** - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgement for bounding box labels based on annotations from individual workers.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationBoundingBox`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationBoundingBox`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationBoundingBox`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationBoundingBox`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationBoundingBox`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationBoundingBox`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationBoundingBox`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationBoundingBox`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationBoundingBox`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationBoundingBox`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationBoundingBox`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationBoundingBox`
         *
         * **Video Frame Object Detection Adjustment** - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to classify and localize objects in a sequence of video frames.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectDetection`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectDetection`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectDetection`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectDetection`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectDetection`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectDetection`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectDetection`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectDetection`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectDetection`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectDetection`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectDetection`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectDetection`
         *
         * **Video Frame Object Tracking Adjustment** - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to track object movement across a sequence of video frames.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectTracking`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectTracking`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectTracking`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectTracking`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectTracking`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectTracking`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectTracking`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectTracking`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectTracking`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectTracking`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectTracking`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectTracking`
         *
         * **3D Point Cloud Object Detection Adjustment** - Use this task type when you want workers to adjust 3D cuboids around objects in a 3D point cloud.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectDetection`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectDetection`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectDetection`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectDetection`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectDetection`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectDetection`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectDetection`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectDetection`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectDetection`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectDetection`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectDetection`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectDetection`
         *
         * **3D Point Cloud Object Tracking Adjustment** - Use this task type when you want workers to adjust 3D cuboids around objects that appear in a sequence of 3D point cloud frames.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectTracking`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectTracking`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectTracking`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectTracking`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectTracking`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectTracking`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectTracking`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectTracking`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectTracking`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectTracking`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectTracking`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectTracking`
         *
         * **3D Point Cloud Semantic Segmentation Adjustment** - Use this task type when you want workers to adjust a point-level semantic segmentation masks using a paint tool.
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
         * + `arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudSemanticSegmentation`
         */
        var annotationConsolidationLambdaArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AnnotationConsolidationConfig) : this() {
            this.annotationConsolidationLambdaArn = x.annotationConsolidationLambdaArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AnnotationConsolidationConfig = AnnotationConsolidationConfig(this)
    }
}
