// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * How long a job is allowed to run, or how many candidates a job is allowed to generate.
 */
class AutoMlJobCompletionCriteria private constructor(builder: Builder) {
    /**
     * The maximum runtime, in seconds, an AutoML job has to complete.
     *
     * If an AutoML job exceeds the maximum runtime, the job is stopped automatically and its processing is ended gracefully. The AutoML job identifies the best model whose training was completed and marks it as the best-performing model. Any unfinished steps of the job, such as automatic one-click Autopilot model deployment, will not be completed.
     */
    val maxAutoMlJobRuntimeInSeconds: kotlin.Int? = builder.maxAutoMlJobRuntimeInSeconds
    /**
     * The maximum number of times a training job is allowed to run.
     */
    val maxCandidates: kotlin.Int? = builder.maxCandidates
    /**
     * The maximum time, in seconds, that each training job is allowed to run as part of a hyperparameter tuning job. For more information, see the used by the action.
     */
    val maxRuntimePerTrainingJobInSeconds: kotlin.Int? = builder.maxRuntimePerTrainingJobInSeconds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoMlJobCompletionCriteria(")
        append("maxAutoMlJobRuntimeInSeconds=$maxAutoMlJobRuntimeInSeconds,")
        append("maxCandidates=$maxCandidates,")
        append("maxRuntimePerTrainingJobInSeconds=$maxRuntimePerTrainingJobInSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxAutoMlJobRuntimeInSeconds ?: 0
        result = 31 * result + (maxCandidates ?: 0)
        result = 31 * result + (maxRuntimePerTrainingJobInSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoMlJobCompletionCriteria

        if (maxAutoMlJobRuntimeInSeconds != other.maxAutoMlJobRuntimeInSeconds) return false
        if (maxCandidates != other.maxCandidates) return false
        if (maxRuntimePerTrainingJobInSeconds != other.maxRuntimePerTrainingJobInSeconds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum runtime, in seconds, an AutoML job has to complete.
         *
         * If an AutoML job exceeds the maximum runtime, the job is stopped automatically and its processing is ended gracefully. The AutoML job identifies the best model whose training was completed and marks it as the best-performing model. Any unfinished steps of the job, such as automatic one-click Autopilot model deployment, will not be completed.
         */
        var maxAutoMlJobRuntimeInSeconds: kotlin.Int? = null
        /**
         * The maximum number of times a training job is allowed to run.
         */
        var maxCandidates: kotlin.Int? = null
        /**
         * The maximum time, in seconds, that each training job is allowed to run as part of a hyperparameter tuning job. For more information, see the used by the action.
         */
        var maxRuntimePerTrainingJobInSeconds: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria) : this() {
            this.maxAutoMlJobRuntimeInSeconds = x.maxAutoMlJobRuntimeInSeconds
            this.maxCandidates = x.maxCandidates
            this.maxRuntimePerTrainingJobInSeconds = x.maxRuntimePerTrainingJobInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.AutoMlJobCompletionCriteria = AutoMlJobCompletionCriteria(this)
    }
}
