// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



class CreateHyperParameterTuningJobRequest private constructor(builder: Builder) {
    /**
     * The HyperParameterTuningJobConfig object that describes the tuning job, including the search strategy, the objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for the tuning job. For more information, see [How Hyperparameter Tuning Works](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html).
     */
    val hyperParameterTuningJobConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig? = builder.hyperParameterTuningJobConfig
    /**
     * The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning job launches. The name must be unique within the same Amazon Web Services account and Amazon Web Services Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The name is not case sensitive.
     */
    val hyperParameterTuningJobName: kotlin.String? = builder.hyperParameterTuningJobName
    /**
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
     *
     * Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The HyperParameterTrainingJobDefinition object that describes the training jobs that this tuning job launches, including static hyperparameters, input data configuration, output data configuration, resource configuration, and stopping condition.
     */
    val trainingJobDefinition: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition? = builder.trainingJobDefinition
    /**
     * A list of the HyperParameterTrainingJobDefinition objects launched for this tuning job.
     */
    val trainingJobDefinitions: List<HyperParameterTrainingJobDefinition>? = builder.trainingJobDefinitions
    /**
     * Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.
     *
     * All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric. If you specify `IDENTICAL_DATA_AND_ALGORITHM` as the `WarmStartType` value for the warm start configuration, the training job that performs the best in the new tuning job is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.
     *
     * All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.
     */
    val warmStartConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig? = builder.warmStartConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateHyperParameterTuningJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateHyperParameterTuningJobRequest(")
        append("hyperParameterTuningJobConfig=$hyperParameterTuningJobConfig,")
        append("hyperParameterTuningJobName=$hyperParameterTuningJobName,")
        append("tags=$tags,")
        append("trainingJobDefinition=$trainingJobDefinition,")
        append("trainingJobDefinitions=$trainingJobDefinitions,")
        append("warmStartConfig=$warmStartConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = hyperParameterTuningJobConfig?.hashCode() ?: 0
        result = 31 * result + (hyperParameterTuningJobName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trainingJobDefinition?.hashCode() ?: 0)
        result = 31 * result + (trainingJobDefinitions?.hashCode() ?: 0)
        result = 31 * result + (warmStartConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateHyperParameterTuningJobRequest

        if (hyperParameterTuningJobConfig != other.hyperParameterTuningJobConfig) return false
        if (hyperParameterTuningJobName != other.hyperParameterTuningJobName) return false
        if (tags != other.tags) return false
        if (trainingJobDefinition != other.trainingJobDefinition) return false
        if (trainingJobDefinitions != other.trainingJobDefinitions) return false
        if (warmStartConfig != other.warmStartConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateHyperParameterTuningJobRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The HyperParameterTuningJobConfig object that describes the tuning job, including the search strategy, the objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for the tuning job. For more information, see [How Hyperparameter Tuning Works](https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html).
         */
        var hyperParameterTuningJobConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig? = null
        /**
         * The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning job launches. The name must be unique within the same Amazon Web Services account and Amazon Web Services Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The name is not case sensitive.
         */
        var hyperParameterTuningJobName: kotlin.String? = null
        /**
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see [Tagging Amazon Web Services Resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
         *
         * Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches.
         */
        var tags: List<Tag>? = null
        /**
         * The HyperParameterTrainingJobDefinition object that describes the training jobs that this tuning job launches, including static hyperparameters, input data configuration, output data configuration, resource configuration, and stopping condition.
         */
        var trainingJobDefinition: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition? = null
        /**
         * A list of the HyperParameterTrainingJobDefinition objects launched for this tuning job.
         */
        var trainingJobDefinitions: List<HyperParameterTrainingJobDefinition>? = null
        /**
         * Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.
         *
         * All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric. If you specify `IDENTICAL_DATA_AND_ALGORITHM` as the `WarmStartType` value for the warm start configuration, the training job that performs the best in the new tuning job is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.
         *
         * All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.
         */
        var warmStartConfig: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateHyperParameterTuningJobRequest) : this() {
            this.hyperParameterTuningJobConfig = x.hyperParameterTuningJobConfig
            this.hyperParameterTuningJobName = x.hyperParameterTuningJobName
            this.tags = x.tags
            this.trainingJobDefinition = x.trainingJobDefinition
            this.trainingJobDefinitions = x.trainingJobDefinitions
            this.warmStartConfig = x.warmStartConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateHyperParameterTuningJobRequest = CreateHyperParameterTuningJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig] inside the given [block]
         */
        fun hyperParameterTuningJobConfig(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig.Builder.() -> kotlin.Unit) {
            this.hyperParameterTuningJobConfig = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition] inside the given [block]
         */
        fun trainingJobDefinition(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition.Builder.() -> kotlin.Unit) {
            this.trainingJobDefinition = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTrainingJobDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig] inside the given [block]
         */
        fun warmStartConfig(block: aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig.Builder.() -> kotlin.Unit) {
            this.warmStartConfig = aws.sdk.kotlin.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig.invoke(block)
        }
    }
}
