// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



class CreateModelPackageRequest private constructor(builder: Builder) {
    /**
     * An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
     */
    val additionalInferenceSpecifications: List<AdditionalInferenceSpecificationDefinition>? = builder.additionalInferenceSpecifications
    /**
     * Whether to certify the model package for listing on Amazon Web Services Marketplace.
     *
     * This parameter is optional for unversioned models, and does not apply to versioned models.
     */
    val certifyForMarketplace: kotlin.Boolean = builder.certifyForMarketplace
    /**
     * A unique token that guarantees that the call to this API is idempotent.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The metadata properties associated with the model package versions.
     */
    val customerMetadataProperties: Map<String, String>? = builder.customerMetadataProperties
    /**
     * The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.
     */
    val domain: kotlin.String? = builder.domain
    /**
     * Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on [Drift Detection against Previous Baselines in SageMaker Pipelines](https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection) in the *Amazon SageMaker Developer Guide*.
     */
    val driftCheckBaselines: aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines? = builder.driftCheckBaselines
    /**
     * Specifies details about inference jobs that can be run with models based on this model package, including the following:
     * + The Amazon ECR paths of containers that contain the inference code and model artifacts.
     * + The instance types that the model package supports for transform jobs and real-time endpoints used for inference.
     * + The input and output content formats that the model package supports for inference.
     */
    val inferenceSpecification: aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification? = builder.inferenceSpecification
    /**
     * Metadata properties of the tracking entity, trial, or trial component.
     */
    val metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = builder.metadataProperties
    /**
     * Whether the model is approved for deployment.
     *
     * This parameter is optional for versioned models, and does not apply to unversioned models.
     *
     * For versioned models, the value of this parameter must be set to `Approved` to deploy the model.
     */
    val modelApprovalStatus: aws.sdk.kotlin.services.sagemaker.model.ModelApprovalStatus? = builder.modelApprovalStatus
    /**
     * A structure that contains model metrics reports.
     */
    val modelMetrics: aws.sdk.kotlin.services.sagemaker.model.ModelMetrics? = builder.modelMetrics
    /**
     * A description of the model package.
     */
    val modelPackageDescription: kotlin.String? = builder.modelPackageDescription
    /**
     * The name or Amazon Resource Name (ARN) of the model package group that this model version belongs to.
     *
     * This parameter is required for versioned models, and does not apply to unversioned models.
     */
    val modelPackageGroupName: kotlin.String? = builder.modelPackageGroupName
    /**
     * The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).
     *
     * This parameter is required for unversioned models. It is not applicable to versioned models.
     */
    val modelPackageName: kotlin.String? = builder.modelPackageName
    /**
     * The Amazon Simple Storage Service (Amazon S3) path where the sample payload are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
     */
    val samplePayloadUrl: kotlin.String? = builder.samplePayloadUrl
    /**
     * Details about the algorithm that was used to create the model package.
     */
    val sourceAlgorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification? = builder.sourceAlgorithmSpecification
    /**
     * A list of key value pairs associated with the model. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification. The following tasks are supported by Inference Recommender: `"IMAGE_CLASSIFICATION"` | `"OBJECT_DETECTION"` | `"TEXT_GENERATION"` |`"IMAGE_SEGMENTATION"` | `"FILL_MASK"` | `"CLASSIFICATION"` | `"REGRESSION"` | `"OTHER"`.
     *
     * Specify "OTHER" if none of the tasks listed fit your use case.
     */
    val task: kotlin.String? = builder.task
    /**
     * Specifies configurations for one or more transform jobs that SageMaker runs to test the model package.
     */
    val validationSpecification: aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification? = builder.validationSpecification

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateModelPackageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateModelPackageRequest(")
        append("additionalInferenceSpecifications=$additionalInferenceSpecifications,")
        append("certifyForMarketplace=$certifyForMarketplace,")
        append("clientToken=$clientToken,")
        append("customerMetadataProperties=$customerMetadataProperties,")
        append("domain=$domain,")
        append("driftCheckBaselines=$driftCheckBaselines,")
        append("inferenceSpecification=$inferenceSpecification,")
        append("metadataProperties=$metadataProperties,")
        append("modelApprovalStatus=$modelApprovalStatus,")
        append("modelMetrics=$modelMetrics,")
        append("modelPackageDescription=$modelPackageDescription,")
        append("modelPackageGroupName=$modelPackageGroupName,")
        append("modelPackageName=$modelPackageName,")
        append("samplePayloadUrl=$samplePayloadUrl,")
        append("sourceAlgorithmSpecification=$sourceAlgorithmSpecification,")
        append("tags=$tags,")
        append("task=$task,")
        append("validationSpecification=$validationSpecification)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInferenceSpecifications?.hashCode() ?: 0
        result = 31 * result + (certifyForMarketplace.hashCode())
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (customerMetadataProperties?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (driftCheckBaselines?.hashCode() ?: 0)
        result = 31 * result + (inferenceSpecification?.hashCode() ?: 0)
        result = 31 * result + (metadataProperties?.hashCode() ?: 0)
        result = 31 * result + (modelApprovalStatus?.hashCode() ?: 0)
        result = 31 * result + (modelMetrics?.hashCode() ?: 0)
        result = 31 * result + (modelPackageDescription?.hashCode() ?: 0)
        result = 31 * result + (modelPackageGroupName?.hashCode() ?: 0)
        result = 31 * result + (modelPackageName?.hashCode() ?: 0)
        result = 31 * result + (samplePayloadUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceAlgorithmSpecification?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (task?.hashCode() ?: 0)
        result = 31 * result + (validationSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateModelPackageRequest

        if (additionalInferenceSpecifications != other.additionalInferenceSpecifications) return false
        if (certifyForMarketplace != other.certifyForMarketplace) return false
        if (clientToken != other.clientToken) return false
        if (customerMetadataProperties != other.customerMetadataProperties) return false
        if (domain != other.domain) return false
        if (driftCheckBaselines != other.driftCheckBaselines) return false
        if (inferenceSpecification != other.inferenceSpecification) return false
        if (metadataProperties != other.metadataProperties) return false
        if (modelApprovalStatus != other.modelApprovalStatus) return false
        if (modelMetrics != other.modelMetrics) return false
        if (modelPackageDescription != other.modelPackageDescription) return false
        if (modelPackageGroupName != other.modelPackageGroupName) return false
        if (modelPackageName != other.modelPackageName) return false
        if (samplePayloadUrl != other.samplePayloadUrl) return false
        if (sourceAlgorithmSpecification != other.sourceAlgorithmSpecification) return false
        if (tags != other.tags) return false
        if (task != other.task) return false
        if (validationSpecification != other.validationSpecification) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateModelPackageRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.
         */
        var additionalInferenceSpecifications: List<AdditionalInferenceSpecificationDefinition>? = null
        /**
         * Whether to certify the model package for listing on Amazon Web Services Marketplace.
         *
         * This parameter is optional for unversioned models, and does not apply to versioned models.
         */
        var certifyForMarketplace: kotlin.Boolean = false
        /**
         * A unique token that guarantees that the call to this API is idempotent.
         */
        var clientToken: kotlin.String? = null
        /**
         * The metadata properties associated with the model package versions.
         */
        var customerMetadataProperties: Map<String, String>? = null
        /**
         * The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.
         */
        var domain: kotlin.String? = null
        /**
         * Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on [Drift Detection against Previous Baselines in SageMaker Pipelines](https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection) in the *Amazon SageMaker Developer Guide*.
         */
        var driftCheckBaselines: aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines? = null
        /**
         * Specifies details about inference jobs that can be run with models based on this model package, including the following:
         * + The Amazon ECR paths of containers that contain the inference code and model artifacts.
         * + The instance types that the model package supports for transform jobs and real-time endpoints used for inference.
         * + The input and output content formats that the model package supports for inference.
         */
        var inferenceSpecification: aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification? = null
        /**
         * Metadata properties of the tracking entity, trial, or trial component.
         */
        var metadataProperties: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties? = null
        /**
         * Whether the model is approved for deployment.
         *
         * This parameter is optional for versioned models, and does not apply to unversioned models.
         *
         * For versioned models, the value of this parameter must be set to `Approved` to deploy the model.
         */
        var modelApprovalStatus: aws.sdk.kotlin.services.sagemaker.model.ModelApprovalStatus? = null
        /**
         * A structure that contains model metrics reports.
         */
        var modelMetrics: aws.sdk.kotlin.services.sagemaker.model.ModelMetrics? = null
        /**
         * A description of the model package.
         */
        var modelPackageDescription: kotlin.String? = null
        /**
         * The name or Amazon Resource Name (ARN) of the model package group that this model version belongs to.
         *
         * This parameter is required for versioned models, and does not apply to unversioned models.
         */
        var modelPackageGroupName: kotlin.String? = null
        /**
         * The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).
         *
         * This parameter is required for unversioned models. It is not applicable to versioned models.
         */
        var modelPackageName: kotlin.String? = null
        /**
         * The Amazon Simple Storage Service (Amazon S3) path where the sample payload are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).
         */
        var samplePayloadUrl: kotlin.String? = null
        /**
         * Details about the algorithm that was used to create the model package.
         */
        var sourceAlgorithmSpecification: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification? = null
        /**
         * A list of key value pairs associated with the model. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
         */
        var tags: List<Tag>? = null
        /**
         * The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification. The following tasks are supported by Inference Recommender: `"IMAGE_CLASSIFICATION"` | `"OBJECT_DETECTION"` | `"TEXT_GENERATION"` |`"IMAGE_SEGMENTATION"` | `"FILL_MASK"` | `"CLASSIFICATION"` | `"REGRESSION"` | `"OTHER"`.
         *
         * Specify "OTHER" if none of the tasks listed fit your use case.
         */
        var task: kotlin.String? = null
        /**
         * Specifies configurations for one or more transform jobs that SageMaker runs to test the model package.
         */
        var validationSpecification: aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateModelPackageRequest) : this() {
            this.additionalInferenceSpecifications = x.additionalInferenceSpecifications
            this.certifyForMarketplace = x.certifyForMarketplace
            this.clientToken = x.clientToken
            this.customerMetadataProperties = x.customerMetadataProperties
            this.domain = x.domain
            this.driftCheckBaselines = x.driftCheckBaselines
            this.inferenceSpecification = x.inferenceSpecification
            this.metadataProperties = x.metadataProperties
            this.modelApprovalStatus = x.modelApprovalStatus
            this.modelMetrics = x.modelMetrics
            this.modelPackageDescription = x.modelPackageDescription
            this.modelPackageGroupName = x.modelPackageGroupName
            this.modelPackageName = x.modelPackageName
            this.samplePayloadUrl = x.samplePayloadUrl
            this.sourceAlgorithmSpecification = x.sourceAlgorithmSpecification
            this.tags = x.tags
            this.task = x.task
            this.validationSpecification = x.validationSpecification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateModelPackageRequest = CreateModelPackageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines] inside the given [block]
         */
        fun driftCheckBaselines(block: aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines.Builder.() -> kotlin.Unit) {
            this.driftCheckBaselines = aws.sdk.kotlin.services.sagemaker.model.DriftCheckBaselines.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification] inside the given [block]
         */
        fun inferenceSpecification(block: aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification.Builder.() -> kotlin.Unit) {
            this.inferenceSpecification = aws.sdk.kotlin.services.sagemaker.model.InferenceSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MetadataProperties] inside the given [block]
         */
        fun metadataProperties(block: aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.Builder.() -> kotlin.Unit) {
            this.metadataProperties = aws.sdk.kotlin.services.sagemaker.model.MetadataProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelMetrics] inside the given [block]
         */
        fun modelMetrics(block: aws.sdk.kotlin.services.sagemaker.model.ModelMetrics.Builder.() -> kotlin.Unit) {
            this.modelMetrics = aws.sdk.kotlin.services.sagemaker.model.ModelMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification] inside the given [block]
         */
        fun sourceAlgorithmSpecification(block: aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification.Builder.() -> kotlin.Unit) {
            this.sourceAlgorithmSpecification = aws.sdk.kotlin.services.sagemaker.model.SourceAlgorithmSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification] inside the given [block]
         */
        fun validationSpecification(block: aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification.Builder.() -> kotlin.Unit) {
            this.validationSpecification = aws.sdk.kotlin.services.sagemaker.model.ModelPackageValidationSpecification.invoke(block)
        }
    }
}
