// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



class CreateUserProfileRequest private constructor(builder: Builder) {
    /**
     * The ID of the associated Domain.
     */
    val domainId: kotlin.String? = builder.domainId
    /**
     * A specifier for the type of value specified in SingleSignOnUserValue. Currently, the only supported value is "UserName". If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode is not SSO, this field cannot be specified.
     */
    val singleSignOnUserIdentifier: kotlin.String? = builder.singleSignOnUserIdentifier
    /**
     * The username of the associated Amazon Web Services Single Sign-On User for this UserProfile. If the Domain's AuthMode is SSO, this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is not SSO, this field cannot be specified.
     */
    val singleSignOnUserValue: kotlin.String? = builder.singleSignOnUserValue
    /**
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
     *
     * Tags that you specify for the User Profile are also added to all Apps that the User Profile launches.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A name for the UserProfile. This value is not case sensitive.
     */
    val userProfileName: kotlin.String? = builder.userProfileName
    /**
     * A collection of settings.
     */
    val userSettings: aws.sdk.kotlin.services.sagemaker.model.UserSettings? = builder.userSettings

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.CreateUserProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUserProfileRequest(")
        append("domainId=$domainId,")
        append("singleSignOnUserIdentifier=$singleSignOnUserIdentifier,")
        append("singleSignOnUserValue=$singleSignOnUserValue,")
        append("tags=$tags,")
        append("userProfileName=$userProfileName,")
        append("userSettings=$userSettings)")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainId?.hashCode() ?: 0
        result = 31 * result + (singleSignOnUserIdentifier?.hashCode() ?: 0)
        result = 31 * result + (singleSignOnUserValue?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userProfileName?.hashCode() ?: 0)
        result = 31 * result + (userSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateUserProfileRequest

        if (domainId != other.domainId) return false
        if (singleSignOnUserIdentifier != other.singleSignOnUserIdentifier) return false
        if (singleSignOnUserValue != other.singleSignOnUserValue) return false
        if (tags != other.tags) return false
        if (userProfileName != other.userProfileName) return false
        if (userSettings != other.userSettings) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.CreateUserProfileRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the associated Domain.
         */
        var domainId: kotlin.String? = null
        /**
         * A specifier for the type of value specified in SingleSignOnUserValue. Currently, the only supported value is "UserName". If the Domain's AuthMode is SSO, this field is required. If the Domain's AuthMode is not SSO, this field cannot be specified.
         */
        var singleSignOnUserIdentifier: kotlin.String? = null
        /**
         * The username of the associated Amazon Web Services Single Sign-On User for this UserProfile. If the Domain's AuthMode is SSO, this field is required, and must match a valid username of a user in your directory. If the Domain's AuthMode is not SSO, this field cannot be specified.
         */
        var singleSignOnUserValue: kotlin.String? = null
        /**
         * Each tag consists of a key and an optional value. Tag keys must be unique per resource.
         *
         * Tags that you specify for the User Profile are also added to all Apps that the User Profile launches.
         */
        var tags: List<Tag>? = null
        /**
         * A name for the UserProfile. This value is not case sensitive.
         */
        var userProfileName: kotlin.String? = null
        /**
         * A collection of settings.
         */
        var userSettings: aws.sdk.kotlin.services.sagemaker.model.UserSettings? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.CreateUserProfileRequest) : this() {
            this.domainId = x.domainId
            this.singleSignOnUserIdentifier = x.singleSignOnUserIdentifier
            this.singleSignOnUserValue = x.singleSignOnUserValue
            this.tags = x.tags
            this.userProfileName = x.userProfileName
            this.userSettings = x.userSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.CreateUserProfileRequest = CreateUserProfileRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.UserSettings] inside the given [block]
         */
        fun userSettings(block: aws.sdk.kotlin.services.sagemaker.model.UserSettings.Builder.() -> kotlin.Unit) {
            this.userSettings = aws.sdk.kotlin.services.sagemaker.model.UserSettings.invoke(block)
        }
    }
}
