// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Configuration information for the Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the `DebugHookConfig` parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job](https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
 */
class DebugHookConfig private constructor(builder: Builder) {
    /**
     * Configuration information for Debugger tensor collections. To learn more about how to configure the `CollectionConfiguration` parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job](https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
     */
    val collectionConfigurations: List<CollectionConfiguration>? = builder.collectionConfigurations
    /**
     * Configuration information for the Debugger hook parameters.
     */
    val hookParameters: Map<String, String>? = builder.hookParameters
    /**
     * Path to local storage location for metrics and tensors. Defaults to `/opt/ml/output/tensors/`.
     */
    val localPath: kotlin.String? = builder.localPath
    /**
     * Path to Amazon S3 storage location for metrics and tensors.
     */
    val s3OutputPath: kotlin.String? = builder.s3OutputPath

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DebugHookConfig(")
        append("collectionConfigurations=$collectionConfigurations,")
        append("hookParameters=$hookParameters,")
        append("localPath=$localPath,")
        append("s3OutputPath=$s3OutputPath)")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionConfigurations?.hashCode() ?: 0
        result = 31 * result + (hookParameters?.hashCode() ?: 0)
        result = 31 * result + (localPath?.hashCode() ?: 0)
        result = 31 * result + (s3OutputPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DebugHookConfig

        if (collectionConfigurations != other.collectionConfigurations) return false
        if (hookParameters != other.hookParameters) return false
        if (localPath != other.localPath) return false
        if (s3OutputPath != other.s3OutputPath) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * Configuration information for Debugger tensor collections. To learn more about how to configure the `CollectionConfiguration` parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job](https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
         */
        var collectionConfigurations: List<CollectionConfiguration>? = null
        /**
         * Configuration information for the Debugger hook parameters.
         */
        var hookParameters: Map<String, String>? = null
        /**
         * Path to local storage location for metrics and tensors. Defaults to `/opt/ml/output/tensors/`.
         */
        var localPath: kotlin.String? = null
        /**
         * Path to Amazon S3 storage location for metrics and tensors.
         */
        var s3OutputPath: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig) : this() {
            this.collectionConfigurations = x.collectionConfigurations
            this.hookParameters = x.hookParameters
            this.localPath = x.localPath
            this.s3OutputPath = x.s3OutputPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DebugHookConfig = DebugHookConfig(this)
    }
}
