// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Configuration information for SageMaker Debugger rules for debugging. To learn more about how to configure the `DebugRuleConfiguration` parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job](https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).
 */
class DebugRuleConfiguration private constructor(builder: Builder) {
    /**
     * The instance type to deploy a Debugger custom rule for debugging a training job.
     */
    val instanceType: aws.sdk.kotlin.services.sagemaker.model.ProcessingInstanceType? = builder.instanceType
    /**
     * Path to local storage location for output of rules. Defaults to `/opt/ml/processing/output/rule/`.
     */
    val localPath: kotlin.String? = builder.localPath
    /**
     * The name of the rule configuration. It must be unique relative to other rule configuration names.
     */
    val ruleConfigurationName: kotlin.String? = builder.ruleConfigurationName
    /**
     * The Amazon Elastic Container (ECR) Image for the managed rule evaluation.
     */
    val ruleEvaluatorImage: kotlin.String? = builder.ruleEvaluatorImage
    /**
     * Runtime configuration for rule container.
     */
    val ruleParameters: Map<String, String>? = builder.ruleParameters
    /**
     * Path to Amazon S3 storage location for rules.
     */
    val s3OutputPath: kotlin.String? = builder.s3OutputPath
    /**
     * The size, in GB, of the ML storage volume attached to the processing instance.
     */
    val volumeSizeInGb: kotlin.Int = builder.volumeSizeInGb

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DebugRuleConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DebugRuleConfiguration(")
        append("instanceType=$instanceType,")
        append("localPath=$localPath,")
        append("ruleConfigurationName=$ruleConfigurationName,")
        append("ruleEvaluatorImage=$ruleEvaluatorImage,")
        append("ruleParameters=$ruleParameters,")
        append("s3OutputPath=$s3OutputPath,")
        append("volumeSizeInGb=$volumeSizeInGb)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceType?.hashCode() ?: 0
        result = 31 * result + (localPath?.hashCode() ?: 0)
        result = 31 * result + (ruleConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (ruleEvaluatorImage?.hashCode() ?: 0)
        result = 31 * result + (ruleParameters?.hashCode() ?: 0)
        result = 31 * result + (s3OutputPath?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInGb)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DebugRuleConfiguration

        if (instanceType != other.instanceType) return false
        if (localPath != other.localPath) return false
        if (ruleConfigurationName != other.ruleConfigurationName) return false
        if (ruleEvaluatorImage != other.ruleEvaluatorImage) return false
        if (ruleParameters != other.ruleParameters) return false
        if (s3OutputPath != other.s3OutputPath) return false
        if (volumeSizeInGb != other.volumeSizeInGb) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DebugRuleConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The instance type to deploy a Debugger custom rule for debugging a training job.
         */
        var instanceType: aws.sdk.kotlin.services.sagemaker.model.ProcessingInstanceType? = null
        /**
         * Path to local storage location for output of rules. Defaults to `/opt/ml/processing/output/rule/`.
         */
        var localPath: kotlin.String? = null
        /**
         * The name of the rule configuration. It must be unique relative to other rule configuration names.
         */
        var ruleConfigurationName: kotlin.String? = null
        /**
         * The Amazon Elastic Container (ECR) Image for the managed rule evaluation.
         */
        var ruleEvaluatorImage: kotlin.String? = null
        /**
         * Runtime configuration for rule container.
         */
        var ruleParameters: Map<String, String>? = null
        /**
         * Path to Amazon S3 storage location for rules.
         */
        var s3OutputPath: kotlin.String? = null
        /**
         * The size, in GB, of the ML storage volume attached to the processing instance.
         */
        var volumeSizeInGb: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DebugRuleConfiguration) : this() {
            this.instanceType = x.instanceType
            this.localPath = x.localPath
            this.ruleConfigurationName = x.ruleConfigurationName
            this.ruleEvaluatorImage = x.ruleEvaluatorImage
            this.ruleParameters = x.ruleParameters
            this.s3OutputPath = x.s3OutputPath
            this.volumeSizeInGb = x.volumeSizeInGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DebugRuleConfiguration = DebugRuleConfiguration(this)
    }
}
