// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeFeatureGroupResponse private constructor(builder: Builder) {
    /**
     * A timestamp indicating when SageMaker created the `FeatureGroup`.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A free form description of the feature group.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the feature that stores the `EventTime` of a Record in a `FeatureGroup`.
     *
     *  An `EventTime` is a point in time when a new event occurs that corresponds to the creation or update of a `Record` in a `FeatureGroup`. All `Records` in the `FeatureGroup` have a corresponding `EventTime`.
     */
    val eventTimeFeatureName: kotlin.String? = builder.eventTimeFeatureName
    /**
     * The reason that the `FeatureGroup` failed to be replicated in the `OfflineStore`. This is failure can occur because:
     * + The `FeatureGroup` could not be created in the `OfflineStore`.
     * + The `FeatureGroup` could not be deleted from the `OfflineStore`.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * A list of the `Features` in the `FeatureGroup`. Each feature is defined by a `FeatureName` and `FeatureType`.
     */
    val featureDefinitions: List<FeatureDefinition>? = builder.featureDefinitions
    /**
     * The Amazon Resource Name (ARN) of the `FeatureGroup`.
     */
    val featureGroupArn: kotlin.String? = builder.featureGroupArn
    /**
     * he name of the `FeatureGroup`.
     */
    val featureGroupName: kotlin.String? = builder.featureGroupName
    /**
     * The status of the feature group.
     */
    val featureGroupStatus: aws.sdk.kotlin.services.sagemaker.model.FeatureGroupStatus? = builder.featureGroupStatus
    /**
     * A token to resume pagination of the list of `Features` (`FeatureDefinitions`).
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The configuration of the `OfflineStore`, inducing the S3 location of the `OfflineStore`, Amazon Web Services Glue or Amazon Web Services Hive data catalogue configurations, and the security configuration.
     */
    val offlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig? = builder.offlineStoreConfig
    /**
     * The status of the `OfflineStore`. Notifies you if replicating data into the `OfflineStore` has failed. Returns either: `Active` or `Blocked`
     */
    val offlineStoreStatus: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus? = builder.offlineStoreStatus
    /**
     * The configuration for the `OnlineStore`.
     */
    val onlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig? = builder.onlineStoreConfig
    /**
     * The name of the `Feature` used for `RecordIdentifier`, whose value uniquely identifies a record stored in the feature store.
     */
    val recordIdentifierFeatureName: kotlin.String? = builder.recordIdentifierFeatureName
    /**
     * The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the `OfflineStore` if an `OfflineStoreConfig` is provided.
     */
    val roleArn: kotlin.String? = builder.roleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeFeatureGroupResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFeatureGroupResponse(")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("eventTimeFeatureName=$eventTimeFeatureName,")
        append("failureReason=$failureReason,")
        append("featureDefinitions=$featureDefinitions,")
        append("featureGroupArn=$featureGroupArn,")
        append("featureGroupName=$featureGroupName,")
        append("featureGroupStatus=$featureGroupStatus,")
        append("nextToken=$nextToken,")
        append("offlineStoreConfig=$offlineStoreConfig,")
        append("offlineStoreStatus=$offlineStoreStatus,")
        append("onlineStoreConfig=$onlineStoreConfig,")
        append("recordIdentifierFeatureName=$recordIdentifierFeatureName,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eventTimeFeatureName?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (featureDefinitions?.hashCode() ?: 0)
        result = 31 * result + (featureGroupArn?.hashCode() ?: 0)
        result = 31 * result + (featureGroupName?.hashCode() ?: 0)
        result = 31 * result + (featureGroupStatus?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (offlineStoreConfig?.hashCode() ?: 0)
        result = 31 * result + (offlineStoreStatus?.hashCode() ?: 0)
        result = 31 * result + (onlineStoreConfig?.hashCode() ?: 0)
        result = 31 * result + (recordIdentifierFeatureName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeFeatureGroupResponse

        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (eventTimeFeatureName != other.eventTimeFeatureName) return false
        if (failureReason != other.failureReason) return false
        if (featureDefinitions != other.featureDefinitions) return false
        if (featureGroupArn != other.featureGroupArn) return false
        if (featureGroupName != other.featureGroupName) return false
        if (featureGroupStatus != other.featureGroupStatus) return false
        if (nextToken != other.nextToken) return false
        if (offlineStoreConfig != other.offlineStoreConfig) return false
        if (offlineStoreStatus != other.offlineStoreStatus) return false
        if (onlineStoreConfig != other.onlineStoreConfig) return false
        if (recordIdentifierFeatureName != other.recordIdentifierFeatureName) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeFeatureGroupResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * A timestamp indicating when SageMaker created the `FeatureGroup`.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A free form description of the feature group.
         */
        var description: kotlin.String? = null
        /**
         * The name of the feature that stores the `EventTime` of a Record in a `FeatureGroup`.
         *
         *  An `EventTime` is a point in time when a new event occurs that corresponds to the creation or update of a `Record` in a `FeatureGroup`. All `Records` in the `FeatureGroup` have a corresponding `EventTime`.
         */
        var eventTimeFeatureName: kotlin.String? = null
        /**
         * The reason that the `FeatureGroup` failed to be replicated in the `OfflineStore`. This is failure can occur because:
         * + The `FeatureGroup` could not be created in the `OfflineStore`.
         * + The `FeatureGroup` could not be deleted from the `OfflineStore`.
         */
        var failureReason: kotlin.String? = null
        /**
         * A list of the `Features` in the `FeatureGroup`. Each feature is defined by a `FeatureName` and `FeatureType`.
         */
        var featureDefinitions: List<FeatureDefinition>? = null
        /**
         * The Amazon Resource Name (ARN) of the `FeatureGroup`.
         */
        var featureGroupArn: kotlin.String? = null
        /**
         * he name of the `FeatureGroup`.
         */
        var featureGroupName: kotlin.String? = null
        /**
         * The status of the feature group.
         */
        var featureGroupStatus: aws.sdk.kotlin.services.sagemaker.model.FeatureGroupStatus? = null
        /**
         * A token to resume pagination of the list of `Features` (`FeatureDefinitions`).
         */
        var nextToken: kotlin.String? = null
        /**
         * The configuration of the `OfflineStore`, inducing the S3 location of the `OfflineStore`, Amazon Web Services Glue or Amazon Web Services Hive data catalogue configurations, and the security configuration.
         */
        var offlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig? = null
        /**
         * The status of the `OfflineStore`. Notifies you if replicating data into the `OfflineStore` has failed. Returns either: `Active` or `Blocked`
         */
        var offlineStoreStatus: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus? = null
        /**
         * The configuration for the `OnlineStore`.
         */
        var onlineStoreConfig: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig? = null
        /**
         * The name of the `Feature` used for `RecordIdentifier`, whose value uniquely identifies a record stored in the feature store.
         */
        var recordIdentifierFeatureName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the `OfflineStore` if an `OfflineStoreConfig` is provided.
         */
        var roleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeFeatureGroupResponse) : this() {
            this.creationTime = x.creationTime
            this.description = x.description
            this.eventTimeFeatureName = x.eventTimeFeatureName
            this.failureReason = x.failureReason
            this.featureDefinitions = x.featureDefinitions
            this.featureGroupArn = x.featureGroupArn
            this.featureGroupName = x.featureGroupName
            this.featureGroupStatus = x.featureGroupStatus
            this.nextToken = x.nextToken
            this.offlineStoreConfig = x.offlineStoreConfig
            this.offlineStoreStatus = x.offlineStoreStatus
            this.onlineStoreConfig = x.onlineStoreConfig
            this.recordIdentifierFeatureName = x.recordIdentifierFeatureName
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeFeatureGroupResponse = DescribeFeatureGroupResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig] inside the given [block]
         */
        fun offlineStoreConfig(block: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig.Builder.() -> kotlin.Unit) {
            this.offlineStoreConfig = aws.sdk.kotlin.services.sagemaker.model.OfflineStoreConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus] inside the given [block]
         */
        fun offlineStoreStatus(block: aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus.Builder.() -> kotlin.Unit) {
            this.offlineStoreStatus = aws.sdk.kotlin.services.sagemaker.model.OfflineStoreStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig] inside the given [block]
         */
        fun onlineStoreConfig(block: aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig.Builder.() -> kotlin.Unit) {
            this.onlineStoreConfig = aws.sdk.kotlin.services.sagemaker.model.OnlineStoreConfig.invoke(block)
        }
    }
}
