// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeModelBiasJobDefinitionResponse private constructor(builder: Builder) {
    /**
     * The time at which the model bias job was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the model bias job.
     */
    val jobDefinitionArn: kotlin.String? = builder.jobDefinitionArn
    /**
     * The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.
     */
    val jobDefinitionName: kotlin.String? = builder.jobDefinitionName
    /**
     * Identifies the resources to deploy for a monitoring job.
     */
    val jobResources: aws.sdk.kotlin.services.sagemaker.model.MonitoringResources? = builder.jobResources
    /**
     * Configures the model bias job to run a specified Docker container image.
     */
    val modelBiasAppSpecification: aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification? = builder.modelBiasAppSpecification
    /**
     * The baseline configuration for a model bias job.
     */
    val modelBiasBaselineConfig: aws.sdk.kotlin.services.sagemaker.model.ModelBiasBaselineConfig? = builder.modelBiasBaselineConfig
    /**
     * Inputs for the model bias job.
     */
    val modelBiasJobInput: aws.sdk.kotlin.services.sagemaker.model.ModelBiasJobInput? = builder.modelBiasJobInput
    /**
     * The output configuration for monitoring jobs.
     */
    val modelBiasJobOutputConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig? = builder.modelBiasJobOutputConfig
    /**
     * Networking options for a model bias job.
     */
    val networkConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig? = builder.networkConfig
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * A time limit for how long the monitoring job is allowed to run before stopping.
     */
    val stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition? = builder.stoppingCondition

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.DescribeModelBiasJobDefinitionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeModelBiasJobDefinitionResponse(")
        append("creationTime=$creationTime,")
        append("jobDefinitionArn=$jobDefinitionArn,")
        append("jobDefinitionName=$jobDefinitionName,")
        append("jobResources=$jobResources,")
        append("modelBiasAppSpecification=$modelBiasAppSpecification,")
        append("modelBiasBaselineConfig=$modelBiasBaselineConfig,")
        append("modelBiasJobInput=$modelBiasJobInput,")
        append("modelBiasJobOutputConfig=$modelBiasJobOutputConfig,")
        append("networkConfig=$networkConfig,")
        append("roleArn=$roleArn,")
        append("stoppingCondition=$stoppingCondition)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (jobDefinitionArn?.hashCode() ?: 0)
        result = 31 * result + (jobDefinitionName?.hashCode() ?: 0)
        result = 31 * result + (jobResources?.hashCode() ?: 0)
        result = 31 * result + (modelBiasAppSpecification?.hashCode() ?: 0)
        result = 31 * result + (modelBiasBaselineConfig?.hashCode() ?: 0)
        result = 31 * result + (modelBiasJobInput?.hashCode() ?: 0)
        result = 31 * result + (modelBiasJobOutputConfig?.hashCode() ?: 0)
        result = 31 * result + (networkConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (stoppingCondition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeModelBiasJobDefinitionResponse

        if (creationTime != other.creationTime) return false
        if (jobDefinitionArn != other.jobDefinitionArn) return false
        if (jobDefinitionName != other.jobDefinitionName) return false
        if (jobResources != other.jobResources) return false
        if (modelBiasAppSpecification != other.modelBiasAppSpecification) return false
        if (modelBiasBaselineConfig != other.modelBiasBaselineConfig) return false
        if (modelBiasJobInput != other.modelBiasJobInput) return false
        if (modelBiasJobOutputConfig != other.modelBiasJobOutputConfig) return false
        if (networkConfig != other.networkConfig) return false
        if (roleArn != other.roleArn) return false
        if (stoppingCondition != other.stoppingCondition) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.DescribeModelBiasJobDefinitionResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time at which the model bias job was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the model bias job.
         */
        var jobDefinitionArn: kotlin.String? = null
        /**
         * The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.
         */
        var jobDefinitionName: kotlin.String? = null
        /**
         * Identifies the resources to deploy for a monitoring job.
         */
        var jobResources: aws.sdk.kotlin.services.sagemaker.model.MonitoringResources? = null
        /**
         * Configures the model bias job to run a specified Docker container image.
         */
        var modelBiasAppSpecification: aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification? = null
        /**
         * The baseline configuration for a model bias job.
         */
        var modelBiasBaselineConfig: aws.sdk.kotlin.services.sagemaker.model.ModelBiasBaselineConfig? = null
        /**
         * Inputs for the model bias job.
         */
        var modelBiasJobInput: aws.sdk.kotlin.services.sagemaker.model.ModelBiasJobInput? = null
        /**
         * The output configuration for monitoring jobs.
         */
        var modelBiasJobOutputConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig? = null
        /**
         * Networking options for a model bias job.
         */
        var networkConfig: aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.
         */
        var roleArn: kotlin.String? = null
        /**
         * A time limit for how long the monitoring job is allowed to run before stopping.
         */
        var stoppingCondition: aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.DescribeModelBiasJobDefinitionResponse) : this() {
            this.creationTime = x.creationTime
            this.jobDefinitionArn = x.jobDefinitionArn
            this.jobDefinitionName = x.jobDefinitionName
            this.jobResources = x.jobResources
            this.modelBiasAppSpecification = x.modelBiasAppSpecification
            this.modelBiasBaselineConfig = x.modelBiasBaselineConfig
            this.modelBiasJobInput = x.modelBiasJobInput
            this.modelBiasJobOutputConfig = x.modelBiasJobOutputConfig
            this.networkConfig = x.networkConfig
            this.roleArn = x.roleArn
            this.stoppingCondition = x.stoppingCondition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.DescribeModelBiasJobDefinitionResponse = DescribeModelBiasJobDefinitionResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringResources] inside the given [block]
         */
        fun jobResources(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringResources.Builder.() -> kotlin.Unit) {
            this.jobResources = aws.sdk.kotlin.services.sagemaker.model.MonitoringResources.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification] inside the given [block]
         */
        fun modelBiasAppSpecification(block: aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification.Builder.() -> kotlin.Unit) {
            this.modelBiasAppSpecification = aws.sdk.kotlin.services.sagemaker.model.ModelBiasAppSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelBiasBaselineConfig] inside the given [block]
         */
        fun modelBiasBaselineConfig(block: aws.sdk.kotlin.services.sagemaker.model.ModelBiasBaselineConfig.Builder.() -> kotlin.Unit) {
            this.modelBiasBaselineConfig = aws.sdk.kotlin.services.sagemaker.model.ModelBiasBaselineConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelBiasJobInput] inside the given [block]
         */
        fun modelBiasJobInput(block: aws.sdk.kotlin.services.sagemaker.model.ModelBiasJobInput.Builder.() -> kotlin.Unit) {
            this.modelBiasJobInput = aws.sdk.kotlin.services.sagemaker.model.ModelBiasJobInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig] inside the given [block]
         */
        fun modelBiasJobOutputConfig(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig.Builder.() -> kotlin.Unit) {
            this.modelBiasJobOutputConfig = aws.sdk.kotlin.services.sagemaker.model.MonitoringOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig] inside the given [block]
         */
        fun networkConfig(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig.Builder.() -> kotlin.Unit) {
            this.networkConfig = aws.sdk.kotlin.services.sagemaker.model.MonitoringNetworkConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition] inside the given [block]
         */
        fun stoppingCondition(block: aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition.Builder.() -> kotlin.Unit) {
            this.stoppingCondition = aws.sdk.kotlin.services.sagemaker.model.MonitoringStoppingCondition.invoke(block)
        }
    }
}
