// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The output configuration.
 */
class EdgeOutputConfig private constructor(builder: Builder) {
    /**
     * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The configuration used to create deployment artifacts. Specify configuration options with a JSON string. The available configuration options for each type are:
     * + `ComponentName` (optional) - Name of the GreenGrass V2 component. If not specified, the default name generated consists of "SagemakerEdgeManager" and the name of your SageMaker Edge Manager packaging job.
     * + `ComponentDescription` (optional) - Description of the component.
     * + `ComponentVersion` (optional) - The version of the component.Amazon Web Services IoT Greengrass uses semantic versions for components. Semantic versions follow a* major.minor.patch* number system. For example, version 1.0.0 represents the first major release for a component. For more information, see the [semantic version specification](https://semver.org/).
     * + `PlatformOS` (optional) - The name of the operating system for the platform. Supported platforms include Windows and Linux.
     * + `PlatformArchitecture` (optional) - The processor architecture for the platform. Supported architectures Windows include: Windows32_x86, Windows64_x64.Supported architectures for Linux include: Linux x86_64, Linux ARMV8.
     */
    val presetDeploymentConfig: kotlin.String? = builder.presetDeploymentConfig
    /**
     * The deployment type SageMaker Edge Manager will create. Currently only supports Amazon Web Services IoT Greengrass Version 2 components.
     */
    val presetDeploymentType: aws.sdk.kotlin.services.sagemaker.model.EdgePresetDeploymentType? = builder.presetDeploymentType
    /**
     * The Amazon Simple Storage (S3) bucker URI.
     */
    val s3OutputLocation: kotlin.String? = builder.s3OutputLocation

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EdgeOutputConfig(")
        append("kmsKeyId=$kmsKeyId,")
        append("presetDeploymentConfig=$presetDeploymentConfig,")
        append("presetDeploymentType=$presetDeploymentType,")
        append("s3OutputLocation=$s3OutputLocation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (presetDeploymentConfig?.hashCode() ?: 0)
        result = 31 * result + (presetDeploymentType?.hashCode() ?: 0)
        result = 31 * result + (s3OutputLocation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EdgeOutputConfig

        if (kmsKeyId != other.kmsKeyId) return false
        if (presetDeploymentConfig != other.presetDeploymentConfig) return false
        if (presetDeploymentType != other.presetDeploymentType) return false
        if (s3OutputLocation != other.s3OutputLocation) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The configuration used to create deployment artifacts. Specify configuration options with a JSON string. The available configuration options for each type are:
         * + `ComponentName` (optional) - Name of the GreenGrass V2 component. If not specified, the default name generated consists of "SagemakerEdgeManager" and the name of your SageMaker Edge Manager packaging job.
         * + `ComponentDescription` (optional) - Description of the component.
         * + `ComponentVersion` (optional) - The version of the component.Amazon Web Services IoT Greengrass uses semantic versions for components. Semantic versions follow a* major.minor.patch* number system. For example, version 1.0.0 represents the first major release for a component. For more information, see the [semantic version specification](https://semver.org/).
         * + `PlatformOS` (optional) - The name of the operating system for the platform. Supported platforms include Windows and Linux.
         * + `PlatformArchitecture` (optional) - The processor architecture for the platform. Supported architectures Windows include: Windows32_x86, Windows64_x64.Supported architectures for Linux include: Linux x86_64, Linux ARMV8.
         */
        var presetDeploymentConfig: kotlin.String? = null
        /**
         * The deployment type SageMaker Edge Manager will create. Currently only supports Amazon Web Services IoT Greengrass Version 2 components.
         */
        var presetDeploymentType: aws.sdk.kotlin.services.sagemaker.model.EdgePresetDeploymentType? = null
        /**
         * The Amazon Simple Storage (S3) bucker URI.
         */
        var s3OutputLocation: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.presetDeploymentConfig = x.presetDeploymentConfig
            this.presetDeploymentType = x.presetDeploymentType
            this.s3OutputLocation = x.s3OutputLocation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.EdgeOutputConfig = EdgeOutputConfig(this)
    }
}
