// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:
 * + CreateProcessingJob
 * + CreateTrainingJob
 * + CreateTransformJob
 */
class ExperimentConfig private constructor(builder: Builder) {
    /**
     * The name of an existing experiment to associate the trial component with.
     */
    val experimentName: kotlin.String? = builder.experimentName
    /**
     * The display name for the trial component. If this key isn't specified, the display name is the trial component name.
     */
    val trialComponentDisplayName: kotlin.String? = builder.trialComponentDisplayName
    /**
     * The name of an existing trial to associate the trial component with. If not specified, a new trial is created.
     */
    val trialName: kotlin.String? = builder.trialName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExperimentConfig(")
        append("experimentName=$experimentName,")
        append("trialComponentDisplayName=$trialComponentDisplayName,")
        append("trialName=$trialName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = experimentName?.hashCode() ?: 0
        result = 31 * result + (trialComponentDisplayName?.hashCode() ?: 0)
        result = 31 * result + (trialName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExperimentConfig

        if (experimentName != other.experimentName) return false
        if (trialComponentDisplayName != other.trialComponentDisplayName) return false
        if (trialName != other.trialName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of an existing experiment to associate the trial component with.
         */
        var experimentName: kotlin.String? = null
        /**
         * The display name for the trial component. If this key isn't specified, the display name is the trial component name.
         */
        var trialComponentDisplayName: kotlin.String? = null
        /**
         * The name of an existing trial to associate the trial component with. If not specified, a new trial is created.
         */
        var trialName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig) : this() {
            this.experimentName = x.experimentName
            this.trialComponentDisplayName = x.trialComponentDisplayName
            this.trialName = x.trialName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ExperimentConfig = ExperimentConfig(this)
    }
}
