// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Contains information about where human output will be stored.
 */
class FlowDefinitionOutputConfig private constructor(builder: Builder) {
    /**
     * The Amazon Key Management Service (KMS) key ID for server-side encryption.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon S3 path where the object containing human output will be made available.
     *
     * To learn more about the format of Amazon A2I output data, see [Amazon A2I Output Data](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-output-data.html).
     */
    val s3OutputPath: kotlin.String? = builder.s3OutputPath

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionOutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FlowDefinitionOutputConfig(")
        append("kmsKeyId=$kmsKeyId,")
        append("s3OutputPath=$s3OutputPath)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (s3OutputPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FlowDefinitionOutputConfig

        if (kmsKeyId != other.kmsKeyId) return false
        if (s3OutputPath != other.s3OutputPath) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionOutputConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Key Management Service (KMS) key ID for server-side encryption.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon S3 path where the object containing human output will be made available.
         *
         * To learn more about the format of Amazon A2I output data, see [Amazon A2I Output Data](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-output-data.html).
         */
        var s3OutputPath: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionOutputConfig) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.s3OutputPath = x.s3OutputPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.FlowDefinitionOutputConfig = FlowDefinitionOutputConfig(this)
    }
}
