// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC).
 */
class ImageConfig private constructor(builder: Builder) {
    /**
     * Set this to one of the following values:
     * + `Platform` - The model image is hosted in Amazon ECR.
     * + `Vpc` - The model image is hosted in a private Docker registry in your VPC.
     */
    val repositoryAccessMode: aws.sdk.kotlin.services.sagemaker.model.RepositoryAccessMode? = builder.repositoryAccessMode
    /**
     * (Optional) Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified `Vpc` as the value for the `RepositoryAccessMode` field, and the private Docker registry where the model image is hosted requires authentication.
     */
    val repositoryAuthConfig: aws.sdk.kotlin.services.sagemaker.model.RepositoryAuthConfig? = builder.repositoryAuthConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ImageConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageConfig(")
        append("repositoryAccessMode=$repositoryAccessMode,")
        append("repositoryAuthConfig=$repositoryAuthConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = repositoryAccessMode?.hashCode() ?: 0
        result = 31 * result + (repositoryAuthConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageConfig

        if (repositoryAccessMode != other.repositoryAccessMode) return false
        if (repositoryAuthConfig != other.repositoryAuthConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ImageConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * Set this to one of the following values:
         * + `Platform` - The model image is hosted in Amazon ECR.
         * + `Vpc` - The model image is hosted in a private Docker registry in your VPC.
         */
        var repositoryAccessMode: aws.sdk.kotlin.services.sagemaker.model.RepositoryAccessMode? = null
        /**
         * (Optional) Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified `Vpc` as the value for the `RepositoryAccessMode` field, and the private Docker registry where the model image is hosted requires authentication.
         */
        var repositoryAuthConfig: aws.sdk.kotlin.services.sagemaker.model.RepositoryAuthConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ImageConfig) : this() {
            this.repositoryAccessMode = x.repositoryAccessMode
            this.repositoryAuthConfig = x.repositoryAuthConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ImageConfig = ImageConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.RepositoryAuthConfig] inside the given [block]
         */
        fun repositoryAuthConfig(block: aws.sdk.kotlin.services.sagemaker.model.RepositoryAuthConfig.Builder.() -> kotlin.Unit) {
            this.repositoryAuthConfig = aws.sdk.kotlin.services.sagemaker.model.RepositoryAuthConfig.invoke(block)
        }
    }
}
