// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Provides configuration information for auto-labeling of your data objects. A `LabelingJobAlgorithmsConfig` object must be supplied in order to use auto-labeling.
 */
class LabelingJobAlgorithmsConfig private constructor(builder: Builder) {
    /**
     * At the end of an auto-label job Ground Truth sends the Amazon Resource Name (ARN) of the final model used for auto-labeling. You can use this model as the starting point for subsequent similar jobs by providing the ARN of the model here.
     */
    val initialActiveLearningModelArn: kotlin.String? = builder.initialActiveLearningModelArn
    /**
     * Specifies the Amazon Resource Name (ARN) of the algorithm used for auto-labeling. You must select one of the following ARNs:
     * + *Image classification*`arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/image-classification`
     * + *Text classification*`arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/text-classification`
     * + *Object detection*`arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/object-detection`
     * + *Semantic Segmentation*`arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/semantic-segmentation`
     */
    val labelingJobAlgorithmSpecificationArn: kotlin.String? = builder.labelingJobAlgorithmSpecificationArn
    /**
     * Provides configuration information for a labeling job.
     */
    val labelingJobResourceConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobResourceConfig? = builder.labelingJobResourceConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LabelingJobAlgorithmsConfig(")
        append("initialActiveLearningModelArn=$initialActiveLearningModelArn,")
        append("labelingJobAlgorithmSpecificationArn=$labelingJobAlgorithmSpecificationArn,")
        append("labelingJobResourceConfig=$labelingJobResourceConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = initialActiveLearningModelArn?.hashCode() ?: 0
        result = 31 * result + (labelingJobAlgorithmSpecificationArn?.hashCode() ?: 0)
        result = 31 * result + (labelingJobResourceConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LabelingJobAlgorithmsConfig

        if (initialActiveLearningModelArn != other.initialActiveLearningModelArn) return false
        if (labelingJobAlgorithmSpecificationArn != other.labelingJobAlgorithmSpecificationArn) return false
        if (labelingJobResourceConfig != other.labelingJobResourceConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * At the end of an auto-label job Ground Truth sends the Amazon Resource Name (ARN) of the final model used for auto-labeling. You can use this model as the starting point for subsequent similar jobs by providing the ARN of the model here.
         */
        var initialActiveLearningModelArn: kotlin.String? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the algorithm used for auto-labeling. You must select one of the following ARNs:
         * + *Image classification*`arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/image-classification`
         * + *Text classification*`arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/text-classification`
         * + *Object detection*`arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/object-detection`
         * + *Semantic Segmentation*`arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/semantic-segmentation`
         */
        var labelingJobAlgorithmSpecificationArn: kotlin.String? = null
        /**
         * Provides configuration information for a labeling job.
         */
        var labelingJobResourceConfig: aws.sdk.kotlin.services.sagemaker.model.LabelingJobResourceConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig) : this() {
            this.initialActiveLearningModelArn = x.initialActiveLearningModelArn
            this.labelingJobAlgorithmSpecificationArn = x.labelingJobAlgorithmSpecificationArn
            this.labelingJobResourceConfig = x.labelingJobResourceConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.LabelingJobAlgorithmsConfig = LabelingJobAlgorithmsConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelingJobResourceConfig] inside the given [block]
         */
        fun labelingJobResourceConfig(block: aws.sdk.kotlin.services.sagemaker.model.LabelingJobResourceConfig.Builder.() -> kotlin.Unit) {
            this.labelingJobResourceConfig = aws.sdk.kotlin.services.sagemaker.model.LabelingJobResourceConfig.invoke(block)
        }
    }
}
