// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides summary information for a work team.
 */
class LabelingJobForWorkteamSummary private constructor(builder: Builder) {
    /**
     * The date and time that the labeling job was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * A unique identifier for a labeling job. You can use this to refer to a specific labeling job.
     */
    val jobReferenceCode: kotlin.String? = builder.jobReferenceCode
    /**
     * Provides information about the progress of a labeling job.
     */
    val labelCounters: aws.sdk.kotlin.services.sagemaker.model.LabelCountersForWorkteam? = builder.labelCounters
    /**
     * The name of the labeling job that the work team is assigned to.
     */
    val labelingJobName: kotlin.String? = builder.labelingJobName
    /**
     * The configured number of workers per data object.
     */
    val numberOfHumanWorkersPerDataObject: kotlin.Int? = builder.numberOfHumanWorkersPerDataObject
    /**
     * The Amazon Web Services account ID of the account used to start the labeling job.
     */
    val workRequesterAccountId: kotlin.String? = builder.workRequesterAccountId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.LabelingJobForWorkteamSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LabelingJobForWorkteamSummary(")
        append("creationTime=$creationTime,")
        append("jobReferenceCode=$jobReferenceCode,")
        append("labelCounters=$labelCounters,")
        append("labelingJobName=$labelingJobName,")
        append("numberOfHumanWorkersPerDataObject=$numberOfHumanWorkersPerDataObject,")
        append("workRequesterAccountId=$workRequesterAccountId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (jobReferenceCode?.hashCode() ?: 0)
        result = 31 * result + (labelCounters?.hashCode() ?: 0)
        result = 31 * result + (labelingJobName?.hashCode() ?: 0)
        result = 31 * result + (numberOfHumanWorkersPerDataObject ?: 0)
        result = 31 * result + (workRequesterAccountId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LabelingJobForWorkteamSummary

        if (creationTime != other.creationTime) return false
        if (jobReferenceCode != other.jobReferenceCode) return false
        if (labelCounters != other.labelCounters) return false
        if (labelingJobName != other.labelingJobName) return false
        if (numberOfHumanWorkersPerDataObject != other.numberOfHumanWorkersPerDataObject) return false
        if (workRequesterAccountId != other.workRequesterAccountId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.LabelingJobForWorkteamSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time that the labeling job was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique identifier for a labeling job. You can use this to refer to a specific labeling job.
         */
        var jobReferenceCode: kotlin.String? = null
        /**
         * Provides information about the progress of a labeling job.
         */
        var labelCounters: aws.sdk.kotlin.services.sagemaker.model.LabelCountersForWorkteam? = null
        /**
         * The name of the labeling job that the work team is assigned to.
         */
        var labelingJobName: kotlin.String? = null
        /**
         * The configured number of workers per data object.
         */
        var numberOfHumanWorkersPerDataObject: kotlin.Int? = null
        /**
         * The Amazon Web Services account ID of the account used to start the labeling job.
         */
        var workRequesterAccountId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.LabelingJobForWorkteamSummary) : this() {
            this.creationTime = x.creationTime
            this.jobReferenceCode = x.jobReferenceCode
            this.labelCounters = x.labelCounters
            this.labelingJobName = x.labelingJobName
            this.numberOfHumanWorkersPerDataObject = x.numberOfHumanWorkersPerDataObject
            this.workRequesterAccountId = x.workRequesterAccountId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.LabelingJobForWorkteamSummary = LabelingJobForWorkteamSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.LabelCountersForWorkteam] inside the given [block]
         */
        fun labelCounters(block: aws.sdk.kotlin.services.sagemaker.model.LabelCountersForWorkteam.Builder.() -> kotlin.Unit) {
            this.labelCounters = aws.sdk.kotlin.services.sagemaker.model.LabelCountersForWorkteam.invoke(block)
        }
    }
}
