// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Output configuration information for a labeling job.
 */
class LabelingJobOutputConfig private constructor(builder: Builder) {
    /**
     * The Amazon Web Services Key Management Service ID of the key used to encrypt the output data, if any.
     *
     * If you provide your own KMS key ID, you must add the required permissions to your KMS key described in [Encrypt Output Data and Storage Volume with Amazon Web Services KMS](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-permission.html#sms-security-kms-permissions).
     *
     * If you don't provide a KMS key ID, Amazon SageMaker uses the default Amazon Web Services KMS key for Amazon S3 for your role's account to encrypt your output data.
     *
     * If you use a bucket policy with an `s3:PutObject` permission that only allows objects with server-side encryption, set the condition key of `s3:x-amz-server-side-encryption` to `"aws:kms"`. For more information, see [KMS-Managed Encryption Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the *Amazon Simple Storage Service Developer Guide.*
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon S3 location to write output data.
     */
    val s3OutputPath: kotlin.String? = builder.s3OutputPath
    /**
     * An Amazon Simple Notification Service (Amazon SNS) output topic ARN. Provide a `SnsTopicArn` if you want to do real time chaining to another streaming job and receive an Amazon SNS notifications each time a data object is submitted by a worker.
     *
     * If you provide an `SnsTopicArn` in `OutputConfig`, when workers complete labeling tasks, Ground Truth will send labeling task output data to the SNS output topic you specify here.
     *
     * To learn more, see [Receive Output Data from a Streaming Labeling Job](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-output-data).
     */
    val snsTopicArn: kotlin.String? = builder.snsTopicArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LabelingJobOutputConfig(")
        append("kmsKeyId=$kmsKeyId,")
        append("s3OutputPath=$s3OutputPath,")
        append("snsTopicArn=$snsTopicArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyId?.hashCode() ?: 0
        result = 31 * result + (s3OutputPath?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LabelingJobOutputConfig

        if (kmsKeyId != other.kmsKeyId) return false
        if (s3OutputPath != other.s3OutputPath) return false
        if (snsTopicArn != other.snsTopicArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services Key Management Service ID of the key used to encrypt the output data, if any.
         *
         * If you provide your own KMS key ID, you must add the required permissions to your KMS key described in [Encrypt Output Data and Storage Volume with Amazon Web Services KMS](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-permission.html#sms-security-kms-permissions).
         *
         * If you don't provide a KMS key ID, Amazon SageMaker uses the default Amazon Web Services KMS key for Amazon S3 for your role's account to encrypt your output data.
         *
         * If you use a bucket policy with an `s3:PutObject` permission that only allows objects with server-side encryption, set the condition key of `s3:x-amz-server-side-encryption` to `"aws:kms"`. For more information, see [KMS-Managed Encryption Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the *Amazon Simple Storage Service Developer Guide.*
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon S3 location to write output data.
         */
        var s3OutputPath: kotlin.String? = null
        /**
         * An Amazon Simple Notification Service (Amazon SNS) output topic ARN. Provide a `SnsTopicArn` if you want to do real time chaining to another streaming job and receive an Amazon SNS notifications each time a data object is submitted by a worker.
         *
         * If you provide an `SnsTopicArn` in `OutputConfig`, when workers complete labeling tasks, Ground Truth will send labeling task output data to the SNS output topic you specify here.
         *
         * To learn more, see [Receive Output Data from a Streaming Labeling Job](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-output-data).
         */
        var snsTopicArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig) : this() {
            this.kmsKeyId = x.kmsKeyId
            this.s3OutputPath = x.s3OutputPath
            this.snsTopicArn = x.snsTopicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.LabelingJobOutputConfig = LabelingJobOutputConfig(this)
    }
}
