// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * Describes the Docker container for the model package.
 */
class ModelPackageContainerDefinition private constructor(builder: Builder) {
    /**
     * The DNS host name for the Docker container.
     */
    val containerHostname: kotlin.String? = builder.containerHostname
    /**
     * The environment variables to set in the Docker container. Each key and value in the `Environment` string to string map can have length of up to 1024. We support up to 16 entries in the map.
     */
    val environment: Map<String, String>? = builder.environment
    /**
     * The machine learning framework of the model package container image.
     */
    val framework: kotlin.String? = builder.framework
    /**
     * The framework version of the Model Package Container Image.
     */
    val frameworkVersion: kotlin.String? = builder.frameworkVersion
    /**
     * The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
     *
     * If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both `registry/repository[:tag]` and `registry/repository[@digest]` image path formats. For more information, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
     */
    val image: kotlin.String? = builder.image
    /**
     * An MD5 hash of the training algorithm that identifies the Docker image used for training.
     */
    val imageDigest: kotlin.String? = builder.imageDigest
    /**
     * The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single `gzip` compressed tar archive (`.tar.gz` suffix).
     *
     * The model artifacts must be in an S3 bucket that is in the same region as the model package.
     */
    val modelDataUrl: kotlin.String? = builder.modelDataUrl
    /**
     * A structure with Model Input details.
     */
    val modelInput: aws.sdk.kotlin.services.sagemaker.model.ModelInput? = builder.modelInput
    /**
     * The name of a pre-trained machine learning benchmarked by Amazon SageMaker Inference Recommender model that matches your model. You can find a list of benchmarked models by calling `ListModelMetadata`.
     */
    val nearestModelName: kotlin.String? = builder.nearestModelName
    /**
     * The Amazon Web Services Marketplace product ID of the model package.
     */
    val productId: kotlin.String? = builder.productId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.ModelPackageContainerDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModelPackageContainerDefinition(")
        append("containerHostname=$containerHostname,")
        append("environment=$environment,")
        append("framework=$framework,")
        append("frameworkVersion=$frameworkVersion,")
        append("image=$image,")
        append("imageDigest=$imageDigest,")
        append("modelDataUrl=$modelDataUrl,")
        append("modelInput=$modelInput,")
        append("nearestModelName=$nearestModelName,")
        append("productId=$productId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerHostname?.hashCode() ?: 0
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (framework?.hashCode() ?: 0)
        result = 31 * result + (frameworkVersion?.hashCode() ?: 0)
        result = 31 * result + (image?.hashCode() ?: 0)
        result = 31 * result + (imageDigest?.hashCode() ?: 0)
        result = 31 * result + (modelDataUrl?.hashCode() ?: 0)
        result = 31 * result + (modelInput?.hashCode() ?: 0)
        result = 31 * result + (nearestModelName?.hashCode() ?: 0)
        result = 31 * result + (productId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModelPackageContainerDefinition

        if (containerHostname != other.containerHostname) return false
        if (environment != other.environment) return false
        if (framework != other.framework) return false
        if (frameworkVersion != other.frameworkVersion) return false
        if (image != other.image) return false
        if (imageDigest != other.imageDigest) return false
        if (modelDataUrl != other.modelDataUrl) return false
        if (modelInput != other.modelInput) return false
        if (nearestModelName != other.nearestModelName) return false
        if (productId != other.productId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.ModelPackageContainerDefinition = Builder(this).apply(block).build()

    class Builder {
        /**
         * The DNS host name for the Docker container.
         */
        var containerHostname: kotlin.String? = null
        /**
         * The environment variables to set in the Docker container. Each key and value in the `Environment` string to string map can have length of up to 1024. We support up to 16 entries in the map.
         */
        var environment: Map<String, String>? = null
        /**
         * The machine learning framework of the model package container image.
         */
        var framework: kotlin.String? = null
        /**
         * The framework version of the Model Package Container Image.
         */
        var frameworkVersion: kotlin.String? = null
        /**
         * The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
         *
         * If you are using your own custom algorithm instead of an algorithm provided by SageMaker, the inference code must meet SageMaker requirements. SageMaker supports both `registry/repository[:tag]` and `registry/repository[@digest]` image path formats. For more information, see [Using Your Own Algorithms with Amazon SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
         */
        var image: kotlin.String? = null
        /**
         * An MD5 hash of the training algorithm that identifies the Docker image used for training.
         */
        var imageDigest: kotlin.String? = null
        /**
         * The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single `gzip` compressed tar archive (`.tar.gz` suffix).
         *
         * The model artifacts must be in an S3 bucket that is in the same region as the model package.
         */
        var modelDataUrl: kotlin.String? = null
        /**
         * A structure with Model Input details.
         */
        var modelInput: aws.sdk.kotlin.services.sagemaker.model.ModelInput? = null
        /**
         * The name of a pre-trained machine learning benchmarked by Amazon SageMaker Inference Recommender model that matches your model. You can find a list of benchmarked models by calling `ListModelMetadata`.
         */
        var nearestModelName: kotlin.String? = null
        /**
         * The Amazon Web Services Marketplace product ID of the model package.
         */
        var productId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.ModelPackageContainerDefinition) : this() {
            this.containerHostname = x.containerHostname
            this.environment = x.environment
            this.framework = x.framework
            this.frameworkVersion = x.frameworkVersion
            this.image = x.image
            this.imageDigest = x.imageDigest
            this.modelDataUrl = x.modelDataUrl
            this.modelInput = x.modelInput
            this.nearestModelName = x.nearestModelName
            this.productId = x.productId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.ModelPackageContainerDefinition = ModelPackageContainerDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.sagemaker.model.ModelInput] inside the given [block]
         */
        fun modelInput(block: aws.sdk.kotlin.services.sagemaker.model.ModelInput.Builder.() -> kotlin.Unit) {
            this.modelInput = aws.sdk.kotlin.services.sagemaker.model.ModelInput.invoke(block)
        }
    }
}
