// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary of information about the last monitoring job to run.
 */
class MonitoringExecutionSummary private constructor(builder: Builder) {
    /**
     * The time at which the monitoring job was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The name of the endpoint used to run the monitoring job.
     */
    val endpointName: kotlin.String? = builder.endpointName
    /**
     * Contains the reason a monitoring job failed, if it failed.
     */
    val failureReason: kotlin.String? = builder.failureReason
    /**
     * A timestamp that indicates the last time the monitoring job was modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The status of the monitoring job.
     */
    val monitoringExecutionStatus: aws.sdk.kotlin.services.sagemaker.model.ExecutionStatus? = builder.monitoringExecutionStatus
    /**
     * The name of the monitoring job.
     */
    val monitoringJobDefinitionName: kotlin.String? = builder.monitoringJobDefinitionName
    /**
     * The name of the monitoring schedule.
     */
    val monitoringScheduleName: kotlin.String? = builder.monitoringScheduleName
    /**
     * The type of the monitoring job.
     */
    val monitoringType: aws.sdk.kotlin.services.sagemaker.model.MonitoringType? = builder.monitoringType
    /**
     * The Amazon Resource Name (ARN) of the monitoring job.
     */
    val processingJobArn: kotlin.String? = builder.processingJobArn
    /**
     * The time the monitoring job was scheduled.
     */
    val scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MonitoringExecutionSummary(")
        append("creationTime=$creationTime,")
        append("endpointName=$endpointName,")
        append("failureReason=$failureReason,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("monitoringExecutionStatus=$monitoringExecutionStatus,")
        append("monitoringJobDefinitionName=$monitoringJobDefinitionName,")
        append("monitoringScheduleName=$monitoringScheduleName,")
        append("monitoringType=$monitoringType,")
        append("processingJobArn=$processingJobArn,")
        append("scheduledTime=$scheduledTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (monitoringExecutionStatus?.hashCode() ?: 0)
        result = 31 * result + (monitoringJobDefinitionName?.hashCode() ?: 0)
        result = 31 * result + (monitoringScheduleName?.hashCode() ?: 0)
        result = 31 * result + (monitoringType?.hashCode() ?: 0)
        result = 31 * result + (processingJobArn?.hashCode() ?: 0)
        result = 31 * result + (scheduledTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MonitoringExecutionSummary

        if (creationTime != other.creationTime) return false
        if (endpointName != other.endpointName) return false
        if (failureReason != other.failureReason) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (monitoringExecutionStatus != other.monitoringExecutionStatus) return false
        if (monitoringJobDefinitionName != other.monitoringJobDefinitionName) return false
        if (monitoringScheduleName != other.monitoringScheduleName) return false
        if (monitoringType != other.monitoringType) return false
        if (processingJobArn != other.processingJobArn) return false
        if (scheduledTime != other.scheduledTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time at which the monitoring job was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the endpoint used to run the monitoring job.
         */
        var endpointName: kotlin.String? = null
        /**
         * Contains the reason a monitoring job failed, if it failed.
         */
        var failureReason: kotlin.String? = null
        /**
         * A timestamp that indicates the last time the monitoring job was modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the monitoring job.
         */
        var monitoringExecutionStatus: aws.sdk.kotlin.services.sagemaker.model.ExecutionStatus? = null
        /**
         * The name of the monitoring job.
         */
        var monitoringJobDefinitionName: kotlin.String? = null
        /**
         * The name of the monitoring schedule.
         */
        var monitoringScheduleName: kotlin.String? = null
        /**
         * The type of the monitoring job.
         */
        var monitoringType: aws.sdk.kotlin.services.sagemaker.model.MonitoringType? = null
        /**
         * The Amazon Resource Name (ARN) of the monitoring job.
         */
        var processingJobArn: kotlin.String? = null
        /**
         * The time the monitoring job was scheduled.
         */
        var scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary) : this() {
            this.creationTime = x.creationTime
            this.endpointName = x.endpointName
            this.failureReason = x.failureReason
            this.lastModifiedTime = x.lastModifiedTime
            this.monitoringExecutionStatus = x.monitoringExecutionStatus
            this.monitoringJobDefinitionName = x.monitoringJobDefinitionName
            this.monitoringScheduleName = x.monitoringScheduleName
            this.monitoringType = x.monitoringType
            this.processingJobArn = x.processingJobArn
            this.scheduledTime = x.scheduledTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.MonitoringExecutionSummary = MonitoringExecutionSummary(this)
    }
}
