// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * The VpcConfig configuration object that specifies the VPC that you want the compilation jobs to connect to. For more information on controlling access to your Amazon S3 buckets used for compilation job, see [Give Amazon SageMaker Compilation Jobs Access to Resources in Your Amazon VPC](https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html).
 */
class NeoVpcConfig private constructor(builder: Builder) {
    /**
     * The VPC security group IDs. IDs have the form of `sg-xxxxxxxx`. Specify the security groups for the VPC that is specified in the `Subnets` field.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The ID of the subnets in the VPC that you want to connect the compilation job to for accessing the model in Amazon S3.
     */
    val subnets: List<String>? = builder.subnets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.NeoVpcConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NeoVpcConfig(")
        append("securityGroupIds=$securityGroupIds,")
        append("subnets=$subnets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = securityGroupIds?.hashCode() ?: 0
        result = 31 * result + (subnets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NeoVpcConfig

        if (securityGroupIds != other.securityGroupIds) return false
        if (subnets != other.subnets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.NeoVpcConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The VPC security group IDs. IDs have the form of `sg-xxxxxxxx`. Specify the security groups for the VPC that is specified in the `Subnets` field.
         */
        var securityGroupIds: List<String>? = null
        /**
         * The ID of the subnets in the VPC that you want to connect the compilation job to for accessing the model in Amazon S3.
         */
        var subnets: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.NeoVpcConfig) : this() {
            this.securityGroupIds = x.securityGroupIds
            this.subnets = x.subnets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.NeoVpcConfig = NeoVpcConfig(this)
    }
}
