// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sagemaker.model



/**
 * A list of nested Filter objects. A resource must satisfy the conditions of all filters to be included in the results returned from the Search API.
 *
 * For example, to filter on a training job's `InputDataConfig` property with a specific channel name and `S3Uri` prefix, define the following filters:
 * + `'{Name:"InputDataConfig.ChannelName", "Operator":"Equals", "Value":"train"}',`
 * + `'{Name:"InputDataConfig.DataSource.S3DataSource.S3Uri", "Operator":"Contains", "Value":"mybucket/catdata"}'`
 */
class NestedFilters private constructor(builder: Builder) {
    /**
     * A list of filters. Each filter acts on a property. Filters must contain at least one `Filters` value. For example, a `NestedFilters` call might include a filter on the `PropertyName` parameter of the `InputDataConfig` property: `InputDataConfig.DataSource.S3DataSource.S3Uri`.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The name of the property to use in the nested filters. The value must match a listed property name, such as `InputDataConfig`.
     */
    val nestedPropertyName: kotlin.String? = builder.nestedPropertyName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sagemaker.model.NestedFilters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NestedFilters(")
        append("filters=$filters,")
        append("nestedPropertyName=$nestedPropertyName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (nestedPropertyName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NestedFilters

        if (filters != other.filters) return false
        if (nestedPropertyName != other.nestedPropertyName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sagemaker.model.NestedFilters = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of filters. Each filter acts on a property. Filters must contain at least one `Filters` value. For example, a `NestedFilters` call might include a filter on the `PropertyName` parameter of the `InputDataConfig` property: `InputDataConfig.DataSource.S3DataSource.S3Uri`.
         */
        var filters: List<Filter>? = null
        /**
         * The name of the property to use in the nested filters. The value must match a listed property name, such as `InputDataConfig`.
         */
        var nestedPropertyName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sagemaker.model.NestedFilters) : this() {
            this.filters = x.filters
            this.nestedPropertyName = x.nestedPropertyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sagemaker.model.NestedFilters = NestedFilters(this)
    }
}
